/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.util.Optional;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.metamodel.util.Facets;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldWithValueSemantics;
import org.apache.isis.viewer.wicket.ui.components.scalars.datepicker.TextFieldWithDateTimePicker;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;

public class ScalarPanelTextFieldWithTemporalPicker<T>
extends ScalarPanelTextFieldWithValueSemantics<T> {
    private static final long serialVersionUID = 1L;

    public ScalarPanelTextFieldWithTemporalPicker(String id, ScalarModel scalarModel, Class<T> cls) {
        super(id, scalarModel, cls);
    }

    protected int getDateRenderAdjustDays() {
        return Facets.dateRenderAdjustDays((ObjectFeature)this.scalarModel().getMetaModel());
    }

    @Override
    protected final TextField<T> createTextField(String id) {
        ScalarModel scalarModel = this.scalarModel();
        TextFieldWithDateTimePicker textField = new TextFieldWithDateTimePicker(id, scalarModel, this.type, this.getConverter(scalarModel));
        textField.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                ScalarPanelTextFieldWithTemporalPicker.this.getScalarModelChangeDispatcher().notifyUpdate(target);
            }
        }});
        return textField;
    }

    protected final TextField<T> getTextField() {
        return (TextField)this.getFormComponent();
    }

    @Override
    protected Optional<ScalarFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(ScalarFragmentFactory.InputFragment.DATE);
    }

    @Override
    protected void installScalarModelChangeBehavior() {
    }
}

