/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.util.Collection;
import java.util.Optional;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.isis.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.metamodel.util.Facets;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelFactory;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.springframework.lang.Nullable;

final class _Util {
    static boolean canPropertyEnterInlineEditDirectly(ScalarModel scalarModel) {
        return scalarModel.getPromptStyle().isInline() && scalarModel.canEnterEditMode();
    }

    static boolean canParameterEnterNestedEdit(ScalarModel scalarModel) {
        return scalarModel.isParameter() && !scalarModel.hasChoices() && _Util.lookupCompositeValueMixinForFeature(scalarModel).isPresent();
    }

    static Optional<LinkAndLabel> lookupMixinForCompositeValueUpdate(ScalarModel scalarModel) {
        return _Util.lookupCompositeValueMixinForFeature(scalarModel).flatMap(compositeValueMixinForFeature -> _Util.toLinkAndLabelWithRuleChecking(compositeValueMixinForFeature, scalarModel)).filter(_Util::guardAgainstInvalidCompositeMixinScenarios);
    }

    static Optional<LinkAndLabel> lookupPropertyActionForInlineEdit(ScalarModel scalarModel) {
        return scalarModel.getAssociatedActions().getFirstAssociatedWithInlineAsIfEdit().flatMap(action -> _Util.toLinkAndLabelWithRuleChecking(action, scalarModel));
    }

    static Can<LinkAndLabel> associatedLinksAndLabels(ScalarModel scalarModel) {
        return (Can)scalarModel.getAssociatedActions().getRemainingAssociated().stream().map(LinkAndLabelFactory.forPropertyOrParameter(scalarModel)).collect(Can.toCan());
    }

    private static Optional<LinkAndLabel> toLinkAndLabelNoRuleChecking(@Nullable ObjectAction action, ScalarModel scalarModel) {
        return Optional.ofNullable(action).map(LinkAndLabelFactory.forPropertyOrParameter(scalarModel));
    }

    private static Optional<LinkAndLabel> toLinkAndLabelWithRuleChecking(@Nullable ObjectAction action, ScalarModel scalarModel) {
        return _Util.toLinkAndLabelNoRuleChecking(action, scalarModel).filter(LinkAndLabel::isVisible).filter(LinkAndLabel::isEnabled);
    }

    static IValidator<Object> createValidatorFor(final ScalarModel scalarModel) {
        return new IValidator<Object>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<Object> validatable) {
                _Util.recoverProposedValue(validatable.getValue(), scalarModel).ifPresent(proposedAdapter -> _Strings.nonEmpty((CharSequence)scalarModel.validate(proposedAdapter)).ifPresent(validationFeedback -> validatable.error((IValidationError)new ValidationError(validationFeedback))));
            }
        };
    }

    private static boolean guardAgainstInvalidCompositeMixinScenarios(LinkAndLabel linkAndLabel) {
        return _Util.guardAgainstInvalidCompositeMixinScenarios(linkAndLabel.getActionModel());
    }

    private static boolean guardAgainstInvalidCompositeMixinScenarios(ActionModel actionModel) {
        _Assert.assertNotNull((Object)actionModel.getInlinePromptContext(), () -> String.format("with feature %s, for composite-value-type mixins to work an InlinePromptContext is required", actionModel.getAction().getFeatureIdentifier()));
        _Assert.assertTrue((actionModel.getPromptStyle() == PromptStyle.INLINE_AS_IF_EDIT ? 1 : 0) != 0, () -> String.format("with feature %s, for composite-value-type mixins to work PromptStyle must be INLINE_AS_IF_EDIT yet found %s", actionModel.getAction().getFeatureIdentifier(), actionModel.getPromptStyle()));
        return true;
    }

    private static Optional<ManagedObject> recoverProposedValue(Object valueObject, ScalarModel scalarModel) {
        if (valueObject instanceof Collection) {
            if (scalarModel.isSingular()) {
                Optional<ManagedObject> unpackedValue = ((Collection)valueObject).stream().limit(1L).map(v -> scalarModel.getObjectManager().adapt(valueObject)).findFirst();
                return unpackedValue;
            }
            Can unpackedValues = (Can)((Collection)valueObject).stream().map(v -> scalarModel.getObjectManager().demementify((ObjectMemento)v)).collect(Can.toCan());
            return Optional.of(ManagedObject.packed((ObjectSpecification)scalarModel.getScalarTypeSpec(), (Can)unpackedValues));
        }
        if (valueObject instanceof ObjectMemento) {
            return Optional.ofNullable(scalarModel.getObjectManager().demementify((ObjectMemento)valueObject));
        }
        return Optional.ofNullable(scalarModel.getObjectManager().adapt(valueObject));
    }

    private static Optional<ObjectAction> lookupCompositeValueMixinForFeature(ScalarModel scalarModel) {
        ObjectSpecification spec = scalarModel.getScalarTypeSpec();
        if (!spec.isValue()) {
            return Optional.empty();
        }
        return (Optional)scalarModel.getSpecialization().fold(param -> Facets.valueCompositeMixinForParameter((ObjectFeature)scalarModel.getMetaModel(), (ParameterNegotiationModel)param.getParameterNegotiationModel(), (int)param.getParameterIndex()), prop -> Facets.valueCompositeMixinForProperty((ObjectFeature)scalarModel.getMetaModel(), (ManagedProperty)prop.getManagedProperty()));
    }

    private _Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

