/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.blobclob;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.isis.applib.services.placeholder.PlaceholderRenderService;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.viewer.commons.model.components.UiString;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelFormFieldAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.IResource;

public abstract class IsisBlobOrClobPanelAbstract<T extends NamedWithMimeType>
extends ScalarPanelFormFieldAbstract<T> {
    private static final long serialVersionUID = 1L;
    private IModel<T> unwrapped;

    protected IsisBlobOrClobPanelAbstract(String id, ScalarModel scalarModel, Class<T> type) {
        super(id, scalarModel, type);
        this.unwrapped = scalarModel.unwrapped(type);
    }

    protected abstract IModel<List<FileUpload>> fileUploadModel();

    protected abstract IResource newResource(T var1);

    @Override
    protected void setupFormatModifiers(EnumSet<ScalarPanelAbstract.FormatModifier> modifiers) {
        modifiers.add(ScalarPanelAbstract.FormatModifier.BLOB);
    }

    @Override
    protected Optional<ScalarFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(ScalarFragmentFactory.InputFragment.FILE);
    }

    @Override
    protected FormComponent createFormComponent(String id, ScalarModel scalarModel) {
        String initialCaption = this.outputFormatAsString();
        FileUploadField fileUploadField = Wkt.fileUploadField(id, initialCaption, this.fileUploadModel());
        this.addAcceptFilterTo((Component)fileUploadField);
        return fileUploadField;
    }

    @Override
    protected UiString obtainOutputFormat() {
        String caption = this.getBlobOrClobFromModel().map(NamedWithMimeType::getName).orElseGet(() -> this.getPlaceholderRenderService().asText(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
        return UiString.text((String)caption);
    }

    @Override
    protected Component createComponentForOutput(String id) {
        Fragment link = ScalarFragmentFactory.CompactFragment.LINK.createFragment(id, (MarkupContainer)this, scalarValueId -> this.createDownloadLink((String)scalarValueId, (IModel<String>)((IModel & Serializable)this::outputFormatAsString)));
        return link;
    }

    private void addAcceptFilterTo(Component component) {
        Wkt.attributeReplace(component, "accept", this.scalarModel().getFileAccept());
    }

    private Optional<T> getBlobOrClobFromModel() {
        return Optional.ofNullable((NamedWithMimeType)this.unwrapped.getObject());
    }

    private Component createDownloadLink(String id, IModel<String> labelModel) {
        return this.getBlobOrClobFromModel().map(this::newResource).map(resource -> Wkt.downloadLinkNoCache(id, resource)).map(linkContainer -> {
            WktTooltips.addTooltip(linkContainer, this.translate("Download file"));
            Wkt.labelAdd(linkContainer, ScalarFragmentFactory.CompactFragment.ID_LINK_LABEL, labelModel);
            return linkContainer;
        }).orElseGet(() -> {
            WebMarkupContainer linkContainer = Wkt.container(id);
            Wkt.markupAdd((MarkupContainer)linkContainer, ScalarFragmentFactory.CompactFragment.ID_LINK_LABEL, this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
            return linkContainer;
        });
    }
}

