/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.bool;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxX;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxXConfig;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.viewer.commons.model.components.UiString;
import org.apache.isis.viewer.wicket.model.models.BooleanModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelFormFieldAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;

public class BooleanPanel
extends ScalarPanelFormFieldAbstract<Boolean> {
    private static final long serialVersionUID = 1L;
    private CheckBoxX checkBox;

    public BooleanPanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel, Boolean.class);
    }

    @Override
    protected void setupFormatModifiers(EnumSet<ScalarPanelAbstract.FormatModifier> modifiers) {
        if (!this.scalarModel().isRequired()) {
            modifiers.add(ScalarPanelAbstract.FormatModifier.TRISTATE);
        }
    }

    @Override
    protected Optional<ScalarFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(ScalarFragmentFactory.InputFragment.CHECKBOX);
    }

    @Override
    protected FormComponent<Boolean> createFormComponent(String id, ScalarModel scalarModel) {
        this.checkBox = Wkt.checkboxX(id, (IModel<Boolean>)BooleanModel.forScalarModel((ScalarModel)scalarModel), scalarModel.isRequired(), CheckBoxXConfig.Sizes.xl);
        return this.checkBox;
    }

    @Override
    protected Component createComponentForOutput(String id) {
        Boolean b = (Boolean)this.scalarModel().getObject().getPojo();
        if (b == null && this.scalarModel().isRequired()) {
            b = false;
        }
        return this.getRenderScenario().isCompact() ? ScalarFragmentFactory.CompactFragment.createCheckboxFragment(id, (MarkupContainer)this, b) : ScalarFragmentFactory.PromptFragment.createCheckboxFragment(id, (MarkupContainer)this, b);
    }

    @Override
    protected UiString obtainOutputFormat() {
        throw _Exceptions.unexpectedCodeReach();
    }

    @Override
    protected void onInitializeEditable() {
        super.onInitializeEditable();
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(true);
    }

    @Override
    protected void onInitializeNotEditable() {
        super.onInitializeNotEditable();
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(false);
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(false);
        Wkt.attributeReplace(this.checkBox, "title", disableReason);
    }

    @Override
    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(false);
        Wkt.attributeReplace(this.checkBox, "title", disableReason);
        target.ifPresent(ajax -> ajax.add(new Component[]{this.checkBox}));
    }

    @Override
    protected void onEditable(Optional<AjaxRequestTarget> target) {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(true);
    }

    @Override
    public String getVariation() {
        return super.getVariation();
    }
}

