/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.choices;

import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.choices.ObjectChoicesSelect2Panel;
import org.apache.isis.viewer.wicket.ui.components.scalars.choices.ValueChoicesSelect2Panel;
import org.apache.isis.viewer.wicket.ui.components.scalars.string.ScalarTitleBadgePanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class ChoicesSelect2PanelFactory
extends ComponentFactoryAbstract {
    private static final long serialVersionUID = 1L;

    public ChoicesSelect2PanelFactory() {
        super(UiComponentType.SCALAR_NAME_AND_VALUE);
    }

    @Override
    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        return this.appliesIf(_Casts.castTo(ScalarModel.class, model).isPresent());
    }

    @Override
    public final Component createComponent(String id, IModel<?> model) {
        ScalarModel scalarModel = (ScalarModel)model;
        ComponentSort componentSort = ComponentSort.valueOf(scalarModel);
        switch (componentSort) {
            case TITLE_BADGE: {
                Class valueType = scalarModel.getScalarTypeSpec().getCorrespondingClass();
                return new ScalarTitleBadgePanel(id, scalarModel, valueType);
            }
            case VALUE_CHOICES: {
                return new ValueChoicesSelect2Panel(id, scalarModel);
            }
            case OBJECT_CHOICES: {
                return new ObjectChoicesSelect2Panel(id, scalarModel);
            }
        }
        throw _Exceptions.unmatchedCase((Object)((Object)componentSort));
    }

    private static enum ComponentSort {
        TITLE_BADGE,
        VALUE_CHOICES,
        OBJECT_CHOICES;


        static ComponentSort valueOf(ScalarModel scalarModel) {
            if (scalarModel.getScalarTypeSpec().isValue() && scalarModel.getChoiceProviderSort().isChoicesAny()) {
                return scalarModel.isViewMode() ? TITLE_BADGE : VALUE_CHOICES;
            }
            return OBJECT_CHOICES;
        }
    }
}

