/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.choices;

import java.util.Optional;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelSelectAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ChoiceProviderForValues;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.FormComponent;
import org.wicketstuff.select2.AbstractSelect2Choice;

public class ValueChoicesSelect2Panel
extends ScalarPanelSelectAbstract
implements ScalarPanelSelectAbstract.ChoiceTitleHandler {
    private static final long serialVersionUID = 1L;
    private final boolean isCompactFormat;

    public ValueChoicesSelect2Panel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.isCompactFormat = !scalarModel.getRenderingHint().isRegular();
    }

    @Override
    protected Component createComponentForOutput(String id) {
        return Wkt.label(id, "placeholder");
    }

    @Override
    protected FormComponent<ManagedObject> createFormComponent(String id, ScalarModel scalarModel) {
        if (this.select2 == null) {
            this.select2 = this.createSelect2(id, ChoiceProviderForValues::new);
        } else {
            this.select2.clearInput();
        }
        AbstractSelect2Choice<ObjectMemento, ?> formComponent = this.select2.asComponent();
        return formComponent;
    }

    @Override
    protected final Optional<ScalarFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(ScalarFragmentFactory.InputFragment.SELECT_VALUE);
    }

    @Override
    protected void onInitializeNotEditable() {
        super.onInitializeNotEditable();
        if (this.isCompactFormat) {
            return;
        }
        this.select2.setEnabled(false);
    }

    @Override
    protected void onInitializeEditable() {
        super.onInitializeEditable();
        if (this.isCompactFormat) {
            return;
        }
        this.select2.setEnabled(true);
        this.clearTitleAttribute();
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        if (this.isCompactFormat) {
            return;
        }
        this.setTitleAttribute(disableReason);
        this.select2.setEnabled(false);
    }

    @Override
    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
        super.onNotEditable(disableReason, target);
        if (this.isCompactFormat) {
            return;
        }
        this.setTitleAttribute(disableReason);
        this.select2.setEnabled(false);
    }

    @Override
    protected void onEditable(Optional<AjaxRequestTarget> target) {
        super.onEditable(target);
        if (this.isCompactFormat) {
            return;
        }
        this.clearTitleAttribute();
        this.select2.setEnabled(true);
    }

    @Override
    public void clearTitleAttribute() {
        MarkupContainer target = this.getRegularFrame();
        WktTooltips.clearTooltip((Component)target);
    }

    @Override
    public void setTitleAttribute(String titleAttribute) {
        if (_Strings.isNullOrEmpty((CharSequence)titleAttribute)) {
            this.clearTitleAttribute();
            return;
        }
        MarkupContainer target = this.getRegularFrame();
        WktTooltips.addTooltip(target, titleAttribute);
    }
}

