/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.datepicker;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerIconConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.DatetimePickerCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.DatetimePickerJsReference;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.util.Locale;
import java.util.Map;
import org.apache.isis.applib.locale.UserLocale;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.value.ConverterBasedOnValueSemantics;
import org.apache.isis.viewer.wicket.ui.components.scalars.datepicker.DateTimeConfig;
import org.apache.isis.viewer.wicket.ui.components.scalars.datepicker._TimeFormatUtil;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.util.convert.IConverter;

public class TextFieldWithDateTimePicker<T>
extends TextField<T>
implements IConverter<T> {
    private static final long serialVersionUID = 1L;
    protected final IConverter<T> converter;
    private final DateTimeConfig config;

    public TextFieldWithDateTimePicker(String id, ScalarModel scalarModel, Class<T> type, IConverter<T> converter) {
        super(id, scalarModel.unwrapped(type), type);
        this.setOutputMarkupId(true);
        this.config = this.createDatePickerConfig(scalarModel.getMetaModelContext(), ((ConverterBasedOnValueSemantics)converter).getEditingPattern(), !scalarModel.isRequired());
        this.converter = converter;
    }

    public T convertToObject(String value, Locale locale) {
        return (T)this.converter.convertToObject(value, locale);
    }

    public String convertToString(T value, Locale locale) {
        return this.converter.convertToString(value, locale);
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (super.getType().isAssignableFrom(type)) {
            return this;
        }
        return super.getConverter(type);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!this.isEnabled()) {
            return;
        }
        this.checkComponentTag(tag, "input");
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"datetimepicker-input"});
        Attributes.set((ComponentTag)tag, (String)"type", (String)"text");
        Attributes.set((ComponentTag)tag, (String)"data-toggle", (String)"datetimepicker");
        Attributes.set((ComponentTag)tag, (String)"data-target", (String)this.getMarkupId());
        Attributes.set((ComponentTag)tag, (String)"autocomplete", (String)"off");
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (!this.isEnabled()) {
            return;
        }
        response.render(DatetimePickerCssReference.asHeaderItem());
        response.render(DatetimePickerJsReference.asHeaderItem());
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript((Config)this.config)));
    }

    private DateTimeConfig createDatePickerConfig(MetaModelContext commonContext, String temporalPattern, boolean isInputNullable) {
        DateTimeConfig config = new DateTimeConfig();
        config.useLocale(commonContext.currentUserLocale().map(UserLocale::getLanguageLocale).orElse(Locale.US));
        config.withFormat(_TimeFormatUtil.convertToMomentJsFormat(temporalPattern));
        config.useCalendarWeeks(true);
        config.useCurrent(false);
        config.withButtons(Map.of("showToday", true, "showClear", isInputNullable, "showClose", true));
        config.withIcons(new DatetimePickerIconConfig().useTimeIcon((IconType)FontAwesome6IconType.clock_r).useDateIcon((IconType)FontAwesome6IconType.calendar_r).useUpIcon((IconType)FontAwesome6IconType.arrow_up_s).useDownIcon((IconType)FontAwesome6IconType.arrow_down_s).usePreviousIcon((IconType)FontAwesome6IconType.chevron_left_s).useNextIcon((IconType)FontAwesome6IconType.chevron_right_s).useTodayIcon((IconType)FontAwesome6IconType.calendar_check_r).useClearIcon((IconType)FontAwesome6IconType.trash_can_r).useCloseIcon((IconType)FontAwesome6IconType.check_s));
        config.minDate(commonContext.getConfiguration().getViewer().getWicket().getDatePicker().getMinDate());
        config.maxDate(commonContext.getConfiguration().getViewer().getWicket().getDatePicker().getMaxDate());
        return config;
    }

    private CharSequence createScript(Config config) {
        String script = JQuery.$((Component)this).chain((CharSequence)"datetimepicker", config, new Config[0]).get();
        return script;
    }
}

