/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.image;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.viewer.commons.model.decorators.FormLabelDecorator;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.image.WicketImageUtil;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktDecorators;
import org.apache.isis.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class JavaAwtImagePanel
extends PanelAbstract<ManagedObject, ScalarModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_NAME = "scalarName";
    private static final String ID_SCALAR_VALUE = "scalarValue";
    private static final String ID_FEEDBACK = "feedback";

    public JavaAwtImagePanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.buildGui();
    }

    private void buildGui() {
        Wkt.add((MarkupContainer)this, this.createScalarNameLabel(ID_SCALAR_NAME));
        Image wicketImage = WicketImageUtil.asWicketImage(ID_SCALAR_VALUE, this.scalarModel()).orElse(null);
        if (wicketImage != null) {
            this.addOrReplace(new Component[]{wicketImage});
            this.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, (Component)wicketImage, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter((Component)wicketImage))});
        } else {
            this.permanentlyHide(ID_SCALAR_VALUE, ID_FEEDBACK);
        }
    }

    protected Label createScalarNameLabel(String id) {
        Model labelCaption = Model.of((Serializable)((Object)this.scalarModel().getFriendlyName()));
        Label scalarNameLabel = Wkt.label(id, (IModel<String>)labelCaption);
        if (_Strings.isNullOrEmpty((CharSequence)((CharSequence)((Object)labelCaption.getObject())))) {
            return scalarNameLabel;
        }
        ScalarModel scalarModel = this.scalarModel();
        WktDecorators.getFormLabel().decorate((Component)scalarNameLabel, FormLabelDecorator.FormLabelDecorationModel.mandatory((scalarModel.isRequired() && scalarModel.isEnabled() ? 1 : 0) != 0));
        scalarModel.getDescribedAs().ifPresent(describedAs -> WktTooltips.addTooltip(scalarNameLabel, describedAs));
        return scalarNameLabel;
    }

    protected final ScalarModel scalarModel() {
        return (ScalarModel)this.getModel();
    }
}

