/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.markup;

import java.io.Serializable;
import org.apache.isis.applib.value.Markup;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.object.ManagedObjects;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupComponent;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.ScalarMarkupPanel;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.StandaloneMarkupPanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class MarkupPanelFactories {
    public static ComponentFactory parented() {
        return new Parented();
    }

    public static ComponentFactory standalone() {
        return new Standalone();
    }

    static class Standalone
    extends StandaloneAbstract<Markup> {
        private static final long serialVersionUID = 1L;

        public Standalone() {
            super(Markup.class);
        }

        @Override
        protected MarkupComponent newMarkupComponent(String id, ValueModel model) {
            return new MarkupComponent(id, (IModel<?>)model);
        }
    }

    static class Parented
    extends ParentedAbstract<Markup> {
        private static final long serialVersionUID = 1L;

        public Parented() {
            super(Markup.class);
        }

        @Override
        protected MarkupComponent newMarkupComponent(String id, ScalarModel model) {
            MarkupComponent markupComponent = new MarkupComponent(id, (IModel<?>)model);
            markupComponent.setEnabled(false);
            return markupComponent;
        }
    }

    public static abstract class StandaloneAbstract<T>
    extends ComponentFactoryAbstract {
        private static final long serialVersionUID = 1L;
        private final Class<T> valueType;

        public StandaloneAbstract(Class<T> valueType) {
            super(UiComponentType.VALUE, StandaloneMarkupPanel.class);
            this.valueType = valueType;
        }

        @Override
        public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
            if (!(model instanceof ValueModel)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            ValueModel valueModel = (ValueModel)model;
            ManagedObject objectAdapter = (ManagedObject)valueModel.getObject();
            if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)objectAdapter)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            return this.appliesIf(this.valueType.isAssignableFrom(objectAdapter.getSpecification().getCorrespondingClass()));
        }

        @Override
        public final Component createComponent(String id, IModel<?> model) {
            return new StandaloneMarkupPanel(id, (ValueModel)model, this::newMarkupComponent);
        }

        protected abstract MarkupComponent newMarkupComponent(String var1, ValueModel var2);
    }

    public static abstract class ParentedAbstract<T extends Serializable>
    extends ComponentFactoryAbstract {
        private static final long serialVersionUID = 1L;
        private final Class<T> valueType;

        public ParentedAbstract(Class<T> valueType) {
            super(UiComponentType.SCALAR_NAME_AND_VALUE, ScalarMarkupPanel.class);
            this.valueType = valueType;
        }

        @Override
        public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
            if (!(model instanceof ScalarModel)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            ScalarModel scalarModel = (ScalarModel)model;
            ObjectSpecification scalarSpec = scalarModel.getScalarTypeSpec();
            Class scalarType = scalarSpec.getCorrespondingClass();
            return this.appliesIf(scalarType.equals(this.valueType));
        }

        @Override
        public final Component createComponent(String id, IModel<?> model) {
            return new ScalarMarkupPanel<T>(id, (ScalarModel)model, this.valueType, this::newMarkupComponent);
        }

        protected abstract MarkupComponent newMarkupComponent(String var1, ScalarModel var2);
    }
}

