/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.markup;

import java.util.EnumSet;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldWithValueSemantics;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupComponent;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupComponentFactory;
import org.apache.wicket.Component;

public class ScalarMarkupPanel<T>
extends ScalarPanelTextFieldWithValueSemantics<T> {
    private static final long serialVersionUID = 1L;
    private final transient MarkupComponentFactory<ScalarModel> markupComponentFactory;

    public ScalarMarkupPanel(String id, ScalarModel scalarModel, Class<T> valueType, MarkupComponentFactory<ScalarModel> markupComponentFactory) {
        super(id, scalarModel, valueType);
        this.markupComponentFactory = markupComponentFactory;
    }

    @Override
    protected void setupFormatModifiers(EnumSet<ScalarPanelAbstract.FormatModifier> modifiers) {
        modifiers.add(ScalarPanelAbstract.FormatModifier.MARKUP);
        modifiers.add(ScalarPanelAbstract.FormatModifier.MULITLINE);
    }

    @Override
    protected Component createComponentForOutput(String id) {
        return this.createMarkupComponent(id);
    }

    protected final MarkupComponent createMarkupComponent(String id) {
        return this.markupComponentFactory.newMarkupComponent(id, this.scalarModel());
    }
}

