/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.markup;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.isis.viewer.commons.prism.Prism;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupComponent_reloadJs;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup._HighlightBehavior;
import org.apache.isis.viewer.wicket.ui.util.PrismResourcesWkt;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

class _HighlightBehaviorPrism
implements _HighlightBehavior {
    private final Prism theme;
    private final AtomicReference<Object> cssResourceReference = new AtomicReference();
    private final AtomicReference<Object> jsResourceReferences = new AtomicReference();

    @Override
    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)this.getCssResourceReference()));
        for (ResourceReference jsRef : this.getJsResourceReferences()) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)jsRef));
        }
    }

    @Override
    public CharSequence htmlContentPostProcess(CharSequence htmlContent) {
        return MarkupComponent_reloadJs.decorate(htmlContent, this.getJsResourceReferences());
    }

    public _HighlightBehaviorPrism(Prism theme) {
        this.theme = theme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceReference getCssResourceReference() {
        Object value = this.cssResourceReference.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.cssResourceReference;
            synchronized (atomicReference) {
                value = this.cssResourceReference.get();
                if (value == null) {
                    CssResourceReference actualValue = PrismResourcesWkt.cssResource(this.theme);
                    value = actualValue == null ? this.cssResourceReference : actualValue;
                    this.cssResourceReference.set(value);
                }
            }
        }
        return (ResourceReference)(value == this.cssResourceReference ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceReference> getJsResourceReferences() {
        Object value = this.jsResourceReferences.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.jsResourceReferences;
            synchronized (atomicReference) {
                value = this.jsResourceReferences.get();
                if (value == null) {
                    List<ResourceReference> actualValue = PrismResourcesWkt.jsResources(this.theme);
                    value = actualValue == null ? this.jsResourceReferences : actualValue;
                    this.jsResourceReferences.set(value);
                }
            }
        }
        return (List)(value == this.jsResourceReferences ? null : value);
    }
}

