/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.standalonecollection;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.config.metamodel.facets.CollectionLayoutConfigOptions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataTableModel;
import org.apache.isis.core.metamodel.util.Facets;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelStandalone;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorProvider;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StandaloneCollectionPanel
extends PanelAbstract<DataTableModel, EntityCollectionModel>
implements CollectionCountProvider,
CollectionPresentationSelectorProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_STANDALONE_COLLECTION = "standaloneCollection";
    private static final String ID_ACTION_NAME = "actionName";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";
    private final CollectionPresentationSelectorPanel selectorDropdownPanel;
    private MarkupContainer outerDiv = new WebMarkupContainer("standaloneCollection");

    public StandaloneCollectionPanel(String id, EntityCollectionModelStandalone collectionModel) {
        super(id, collectionModel);
        this.addOrReplace(new Component[]{this.outerDiv});
        DataTableModel table = collectionModel.getDataTableModel();
        Identifier featureId = collectionModel.getIdentifier();
        Wkt.labelAdd(this.outerDiv, ID_ACTION_NAME, (String)table.getTitle().getValue());
        Wkt.cssAppend(this.outerDiv, featureId);
        Wkt.cssAppend(this.outerDiv, collectionModel.getElementType().getFeatureIdentifier());
        Facets.tableDecoration((FacetHolder)collectionModel.getElementType()).map(CollectionLayoutConfigOptions.TableDecoration::cssClass).ifPresent(tableDecorationCssClass -> Wkt.cssAppend(this.outerDiv, tableDecorationCssClass));
        CollectionPresentationSelectorHelper selectorHelper = new CollectionPresentationSelectorHelper((EntityCollectionModel)collectionModel, this.getComponentFactoryRegistry());
        List<ComponentFactory> componentFactories = selectorHelper.getComponentFactories();
        if (componentFactories.size() <= 1) {
            WktComponents.permanentlyHide(this.outerDiv, ID_SELECTOR_DROPDOWN);
            this.selectorDropdownPanel = null;
        } else {
            CollectionPresentationSelectorPanel selectorDropdownPanel = new CollectionPresentationSelectorPanel(ID_SELECTOR_DROPDOWN, (EntityCollectionModel)collectionModel);
            Model componentFactoryModel = new Model();
            String selected = selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanel);
            ComponentFactory selectedComponentFactory = selectorHelper.find(selected);
            componentFactoryModel.setObject((Serializable)selectedComponentFactory);
            this.outerDiv.setOutputMarkupId(true);
            this.outerDiv.addOrReplace(new Component[]{selectorDropdownPanel});
            this.selectorDropdownPanel = selectorDropdownPanel;
        }
        this.getComponentFactoryRegistry().addOrReplaceComponent(this.outerDiv, UiComponentType.COLLECTION_CONTENTS, (IModel<?>)collectionModel);
    }

    @Override
    public CollectionPresentationSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    @Override
    public Integer getCount() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        return model.getElementCount();
    }
}

