/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.tree;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.applib.graph.tree.TreeAdapter;
import org.apache.isis.applib.graph.tree.TreeNode;
import org.apache.isis.applib.graph.tree.TreePath;
import org.apache.isis.applib.graph.tree.TreeState;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.commons.functional.IndexedFunction;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.object.ManagedObjects;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.UiObjectWkt;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.model.util.WktContext;
import org.apache.isis.viewer.wicket.ui.components.entity.icontitle.EntityIconAndTitlePanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.NestedTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.Node;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

class IsisToWicketTreeAdapter {
    IsisToWicketTreeAdapter() {
    }

    public static Component adapt(String id, ValueModel valueModel) {
        if (valueModel == null || valueModel.getObject() == null) {
            return IsisToWicketTreeAdapter.emptyTreeComponent(id);
        }
        MetaModelContext commonContext = valueModel.getMetaModelContext();
        ManagedObject treeNode = (ManagedObject)valueModel.getObject();
        return new EntityTree(id, IsisToWicketTreeAdapter.toITreeProvider(commonContext, treeNode), IsisToWicketTreeAdapter.toIModelRepresentingCollapseExpandState(commonContext, treeNode));
    }

    public static Component adapt(String id, ScalarModel scalarModel) {
        if (scalarModel == null || scalarModel.getObject() == null) {
            return IsisToWicketTreeAdapter.emptyTreeComponent(id);
        }
        MetaModelContext commonContext = scalarModel.getMetaModelContext();
        ManagedObject treeNode = scalarModel.getObject();
        return new EntityTree(id, IsisToWicketTreeAdapter.toITreeProvider(commonContext, treeNode), IsisToWicketTreeAdapter.toIModelRepresentingCollapseExpandState(commonContext, treeNode));
    }

    private static Component emptyTreeComponent(String id) {
        return new Label(id);
    }

    private static ITreeProvider<TreeModel> toITreeProvider(MetaModelContext commonContext, ManagedObject treeNodeObject) {
        TreeNode treeNode = (TreeNode)treeNodeObject.getPojo();
        Class treeAdapterClass = treeNode.getTreeAdapterClass();
        TreeModelTreeAdapter wrappingTreeAdapter = new TreeModelTreeAdapter(commonContext, treeAdapterClass);
        return new TreeModelTreeProvider(wrappingTreeAdapter.wrap(treeNode.getValue(), treeNode.getPositionAsPath()), wrappingTreeAdapter);
    }

    private static TreeExpansionModel toIModelRepresentingCollapseExpandState(MetaModelContext commonContext, ManagedObject treeNodeObject) {
        TreeNode treeNode = (TreeNode)treeNodeObject.getPojo();
        TreeState treeState = treeNode.getTreeState();
        return TreeExpansionModel.of(commonContext, treeState.getExpandedNodePaths());
    }

    private static class TreeExpansionModel
    implements IModel<Set<TreeModel>> {
        private static final long serialVersionUID = 648152234030889164L;
        private final Set<TreePath> expandedTreePaths;
        private final Set<TreeModel> expandedNodes;

        public static TreeExpansionModel of(MetaModelContext commonContext, Set<TreePath> expandedTreePaths) {
            return new TreeExpansionModel(commonContext, expandedTreePaths);
        }

        public void onExpand(TreeModel t) {
            this.expandedTreePaths.add(t.getTreePath());
        }

        public void onCollapse(TreeModel t) {
            this.expandedTreePaths.remove(t.getTreePath());
        }

        public boolean contains(TreePath treePath) {
            return this.expandedTreePaths.contains(treePath);
        }

        private TreeExpansionModel(MetaModelContext commonContext, Set<TreePath> expandedTreePaths) {
            this.expandedTreePaths = expandedTreePaths;
            this.expandedNodes = expandedTreePaths.stream().map(tPath -> new TreeModel(commonContext, (TreePath)tPath)).collect(Collectors.toSet());
        }

        public Set<TreeModel> getObject() {
            return this.expandedNodes;
        }

        public String toString() {
            return "{" + this.expandedTreePaths.stream().map(Object::toString).collect(Collectors.joining(", ")) + "}";
        }
    }

    private static class LoadableDetachableTreeModel
    extends LoadableDetachableModel<TreeModel> {
        private static final long serialVersionUID = 1L;
        private final Bookmark bookmark;
        private final TreePath treePath;
        private final int hashCode;
        private transient MetaModelContext commonContext;

        public LoadableDetachableTreeModel(TreeModel tModel) {
            super((Object)tModel);
            this.treePath = tModel.getTreePath();
            this.bookmark = ManagedObjects.bookmarkElseFail((ManagedObject)((ManagedObject)tModel.getObject()));
            this.hashCode = Objects.hash(this.bookmark.hashCode(), this.treePath.hashCode());
            this.commonContext = tModel.getMetaModelContext();
        }

        protected TreeModel load() {
            this.commonContext = WktContext.computeIfAbsent((MetaModelContext)this.commonContext);
            Bookmark oid = this.bookmark;
            ManagedObject objAdapter = (ManagedObject)this.commonContext.getMetaModelContext().getObjectManager().loadObject(oid).orElseThrow(() -> new NoSuchElementException(String.format("Tree creation: could not recreate TreeModel from Bookmark: '%s'", this.bookmark)));
            Object pojo = objAdapter.getPojo();
            if (pojo == null) {
                throw new NoSuchElementException(String.format("Tree creation: could not recreate Pojo from Oid: '%s'", this.bookmark));
            }
            return new TreeModel(this.commonContext, objAdapter, this.treePath);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LoadableDetachableTreeModel) {
                LoadableDetachableTreeModel other = (LoadableDetachableTreeModel)((Object)obj);
                return this.treePath.equals(other.treePath) && this.bookmark.equals(other.bookmark);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class TreeModelTreeProvider
    implements ITreeProvider<TreeModel> {
        private static final long serialVersionUID = 1L;
        private final TreeModel primaryValue;
        private final TreeModelTreeAdapter treeAdapter;

        private TreeModelTreeProvider(TreeModel primaryValue, TreeModelTreeAdapter treeAdapter) {
            this.primaryValue = primaryValue;
            this.treeAdapter = treeAdapter;
        }

        public void detach() {
        }

        public Iterator<? extends TreeModel> getRoots() {
            return _Lists.singleton((Object)((Object)this.primaryValue)).iterator();
        }

        public boolean hasChildren(TreeModel node) {
            return this.treeAdapter.childCountOf(node) > 0;
        }

        public Iterator<? extends TreeModel> getChildren(TreeModel node) {
            return this.treeAdapter.childrenOf(node).iterator();
        }

        public IModel<TreeModel> model(TreeModel treeModel) {
            return treeModel.isTreePathModelOnly() ? Model.of((Serializable)((Object)treeModel)) : new LoadableDetachableTreeModel(treeModel);
        }
    }

    private static class TreeModelTreeAdapter
    implements TreeAdapter<TreeModel>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<? extends TreeAdapter> treeAdapterClass;
        private transient TreeAdapter wrappedTreeAdapter;
        private transient MetaModelContext commonContext;
        private transient FactoryService factoryService;
        private transient Function<Object, ManagedObject> pojoToAdapter;

        private TreeModelTreeAdapter(MetaModelContext commonContext, Class<? extends TreeAdapter> treeAdapterClass) {
            this.treeAdapterClass = treeAdapterClass;
            this.init(commonContext);
        }

        private void init(MetaModelContext commonContext) {
            this.commonContext = commonContext;
            this.factoryService = (FactoryService)commonContext.lookupServiceElseFail(FactoryService.class);
            this.pojoToAdapter = pojo -> ManagedObject.adaptSingular((SpecificationLoader)commonContext.getSpecificationLoader(), (Object)pojo);
        }

        private TreeAdapter wrappedTreeAdapter() {
            if (this.wrappedTreeAdapter != null) {
                return this.wrappedTreeAdapter;
            }
            try {
                this.ensureInit();
                this.wrappedTreeAdapter = (TreeAdapter)this.factoryService.getOrCreate(this.treeAdapterClass);
                return this.wrappedTreeAdapter;
            }
            catch (Exception e) {
                throw new RuntimeException("failed to instantiate tree adapter", e);
            }
        }

        public Optional<TreeModel> parentOf(TreeModel treeModel) {
            if (treeModel == null) {
                return Optional.empty();
            }
            return this.wrappedTreeAdapter().parentOf(this.unwrap(treeModel)).map(pojo -> this.wrap(pojo, treeModel.getTreePath().getParentIfAny()));
        }

        public int childCountOf(TreeModel treeModel) {
            if (treeModel == null) {
                return 0;
            }
            return this.wrappedTreeAdapter().childCountOf(this.unwrap(treeModel));
        }

        public Stream<TreeModel> childrenOf(TreeModel treeModel) {
            if (treeModel == null) {
                return Stream.empty();
            }
            return this.wrappedTreeAdapter().childrenOf(this.unwrap(treeModel)).map(this.newPojoToTreeModelMapper(treeModel));
        }

        private TreeModel wrap(@NonNull Object pojo, TreePath treePath) {
            if (pojo == null) {
                throw new NullPointerException("pojo is marked non-null but is null");
            }
            this.ensureInit();
            ManagedObject objectAdapter = this.pojoToAdapter.apply(pojo);
            return new TreeModel(this.commonContext, objectAdapter, treePath);
        }

        private Object unwrap(TreeModel model) {
            Objects.requireNonNull(model);
            return ((ManagedObject)model.getObject()).getPojo();
        }

        private Function<Object, TreeModel> newPojoToTreeModelMapper(TreeModel parent) {
            return IndexedFunction.zeroBased((indexWithinSiblings, pojo) -> this.wrap(pojo, parent.getTreePath().append(indexWithinSiblings)));
        }

        private void ensureInit() {
            if (this.commonContext != null) {
                return;
            }
            this.init(WktContext.getMetaModelContext());
        }
    }

    private static class TreeModel
    extends UiObjectWkt {
        private static final long serialVersionUID = 8916044984628849300L;
        private final TreePath treePath;
        private final boolean isTreePathModelOnly;

        public TreeModel(MetaModelContext commonContext, TreePath treePath) {
            super(commonContext, commonContext.getObjectManager().adapt((Object)0));
            this.treePath = treePath;
            this.isTreePathModelOnly = true;
        }

        public TreeModel(MetaModelContext commonContext, ManagedObject adapter, TreePath treePath) {
            super(commonContext, Objects.requireNonNull(adapter));
            this.treePath = treePath;
            this.isTreePathModelOnly = false;
        }

        public TreePath getTreePath() {
            return this.treePath;
        }

        public boolean isTreePathModelOnly() {
            return this.isTreePathModelOnly;
        }
    }

    private static class EntityTree
    extends NestedTree<TreeModel> {
        private static final long serialVersionUID = 1L;

        public EntityTree(String id, ITreeProvider<TreeModel> provider, TreeExpansionModel collapseExpandState) {
            super(id, provider, (IModel)collapseExpandState);
        }

        protected Component newContentComponent(String id, IModel<TreeModel> node) {
            TreeModel treeModel = (TreeModel)((Object)node.getObject());
            EntityIconAndTitlePanel entityIconAndTitle = new EntityIconAndTitlePanel(id, (ObjectAdapterModel)treeModel);
            return entityIconAndTitle;
        }

        public Component newNodeComponent(String id, IModel<TreeModel> model) {
            Node<TreeModel> node = new Node<TreeModel>(id, (AbstractTree)this, model){
                private static final long serialVersionUID = 1L;

                protected Component createContent(String id, IModel<TreeModel> model) {
                    return this.newContentComponent(id, model);
                }

                protected MarkupContainer createJunctionComponent(String id) {
                    final 1 node = this;
                    final Runnable toggleExpandCollapse = () -> (this).toggle();
                    return new AjaxFallbackLink<Void>(id){
                        private static final long serialVersionUID = 1L;

                        public void onClick(Optional<AjaxRequestTarget> target) {
                            toggleExpandCollapse.run();
                        }

                        public boolean isEnabled() {
                            return this.getProvider().hasChildren((Object)((TreeModel)((Object)node.getModelObject())));
                        }

                        public boolean isEnabledInHierarchy() {
                            return true;
                        }
                    };
                }
            };
            node.setOutputMarkupId(true);
            return node;
        }

        public AbstractTree.State getState(TreeModel t) {
            TreeExpansionModel treeExpansionModel = (TreeExpansionModel)this.getModel();
            return treeExpansionModel.contains(t.getTreePath()) ? AbstractTree.State.EXPANDED : AbstractTree.State.COLLAPSED;
        }

        public void expand(TreeModel t) {
            TreeExpansionModel treeExpansionModel = (TreeExpansionModel)this.getModel();
            treeExpansionModel.onExpand(t);
            super.expand((Object)t);
        }

        public void collapse(TreeModel t) {
            TreeExpansionModel treeExpansionModel = (TreeExpansionModel)this.getModel();
            treeExpansionModel.onCollapse(t);
            super.collapse((Object)t);
        }
    }
}

