/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.tree;

import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.components.tree.IsisToWicketTreeAdapter;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;

public class ParentedTreePanel
extends ScalarPanelAbstract2 {
    private static final long serialVersionUID = 1L;

    public ParentedTreePanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected MarkupContainer createRegularFrame() {
        return ScalarFragmentFactory.FrameFragment.REGULAR.createComponent(this::createTreeComponent);
    }

    protected MarkupContainer createCompactFrame() {
        return ScalarFragmentFactory.FrameFragment.COMPACT.createComponent(this::createTreeComponent);
    }

    @Override
    protected Component getValidationFeedbackReceiver() {
        return null;
    }

    private MarkupContainer createTreeComponent(String id) {
        WebMarkupContainer container = this.getScalarFrameContainer();
        ScalarModel scalarModel = this.scalarModel();
        Component tree = IsisToWicketTreeAdapter.adapt(id, scalarModel);
        container.add(new Component[]{tree});
        container.add(new Behavior[]{this.getTreeThemeProvider().treeThemeFor(scalarModel)});
        return (MarkupContainer)tree;
    }
}

