/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.behavior.Draggable;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.behavior.DraggableConfig;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class ModalDialog<T>
extends Modal<T>
implements ActionPrompt {
    private static final long serialVersionUID = 1L;

    public ModalDialog(String markupId) {
        this(markupId, null);
    }

    public ModalDialog(String id, IModel<T> model) {
        super(id, model);
        this.setFadeIn(false);
        this.setUseKeyboard(true);
        this.setDisableEnforceFocus(true);
        this.setOutputMarkupPlaceholderTag(true);
        Wkt.containerAdd((MarkupContainer)this, this.getContentId());
    }

    public void setTitle(Component component, AjaxRequestTarget target) {
        ((MarkupContainer)this.get("dialog:header")).addOrReplace(new Component[]{component});
    }

    public void setPanel(Component component, AjaxRequestTarget target) {
        this.addOrReplace(new Component[]{component});
        this.showPrompt(target);
    }

    public void showPrompt(AjaxRequestTarget target) {
        this.setVisible(true);
        target.add(new Component[]{this});
        this.show((IPartialPageRequestHandler)target);
    }

    public String getTitleId() {
        return "header-label";
    }

    public String getContentId() {
        return "content";
    }

    public void closePrompt(AjaxRequestTarget target) {
        this.addJavaScriptForClosing(target);
        this.setVisible(false);
    }

    protected WebMarkupContainer createDialog(String id) {
        WebMarkupContainer dialog = super.createDialog(id);
        Wkt.cssAppend(dialog, "modal-dialog-center");
        dialog.add(new Behavior[]{new Draggable(new DraggableConfig().withHandle(".modal-header").withCursor("move"))});
        return dialog;
    }

    private void addJavaScriptForClosing(AjaxRequestTarget target) {
        if (target != null) {
            this.close((IPartialPageRequestHandler)target);
        }
    }
}

