/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.entitysimplelink;

import org.apache.isis.applib.services.i18n.TranslationContext;
import org.apache.isis.applib.services.placeholder.PlaceholderRenderService;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.core.metamodel.context.HasMetaModelContext;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.object.ManagedObjects;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.CancelHintRequired;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.FormComponentPanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;

public class EntityLinkSimplePanel
extends FormComponentPanelAbstract<ManagedObject>
implements CancelHintRequired {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_ICON_AND_TITLE = "entityIconAndTitle";
    private static final String ID_ENTITY_TITLE_NULL = "entityTitleNull";

    public EntityLinkSimplePanel(String id, IModel<ManagedObject> model) {
        super(id, model);
        _Assert.assertTrue((boolean)(model instanceof HasMetaModelContext));
        this.setType(ManagedObject.class);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        IModel objectModelForLink = this.getModel();
        boolean isEmpty = ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)((ManagedObject)objectModelForLink.getObject()));
        if (isEmpty) {
            Wkt.markupAdd((MarkupContainer)this, ID_ENTITY_TITLE_NULL, this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
            this.permanentlyHide(ID_ENTITY_ICON_AND_TITLE);
        } else {
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(UiComponentType.ENTITY_ICON_AND_TITLE, objectModelForLink);
            Component component = componentFactory.createComponent(ID_ENTITY_ICON_AND_TITLE, objectModelForLink);
            this.addOrReplace(new Component[]{component});
            this.permanentlyHide(ID_ENTITY_TITLE_NULL);
        }
    }

    public FormComponent<ManagedObject> setModelObject(ManagedObject object) {
        return this;
    }

    public void updateModel() {
    }

    @Override
    public void onCancel() {
    }

    public void validate() {
    }

    public final String translate(String input) {
        return this.getMetaModelContext().getTranslationService().translate(TranslationContext.empty(), input);
    }

    private PlaceholderRenderService getPlaceholderRenderService() {
        return this.getMetaModelContext().getPlaceholderRenderService();
    }

    private MetaModelContext getMetaModelContext() {
        return ((HasMetaModelContext)this.getModel()).getMetaModelContext();
    }
}

