/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent;

import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.HasComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;

public abstract class FormComponentPanelAbstract<T>
extends FormComponentPanel<T> {
    private static final long serialVersionUID = 1L;
    private UiComponentType uiComponentType;

    public FormComponentPanelAbstract(String id, IModel<T> model) {
        super(id, model);
        this.uiComponentType = UiComponentType.lookup((String)id);
    }

    public UiComponentType getComponentType() {
        return this.uiComponentType;
    }

    protected Component addOrReplace(UiComponentType uiComponentType, IModel<?> model) {
        return this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, uiComponentType, model);
    }

    protected void permanentlyHide(UiComponentType ... componentIds) {
        this.permanentlyHide((MarkupContainer)this, componentIds);
    }

    public void permanentlyHide(String ... ids) {
        this.permanentlyHide((MarkupContainer)this, ids);
    }

    protected void permanentlyHide(MarkupContainer container, UiComponentType ... componentIds) {
        WktComponents.permanentlyHide(container, componentIds);
    }

    public void permanentlyHide(MarkupContainer container, String ... ids) {
        WktComponents.permanentlyHide(container, ids);
    }

    public UiHintContainer getHintContainer() {
        return this.hintContainerOf((Component)this);
    }

    private UiHintContainer hintContainerOf(Component component) {
        if (component == null) {
            return null;
        }
        IModel model = component.getDefaultModel();
        if (model instanceof UiHintContainer) {
            return (UiHintContainer)model;
        }
        return this.hintContainerOf((Component)this.getParent());
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        HasComponentFactoryRegistry cfra = (HasComponentFactoryRegistry)this.getApplication();
        return cfra.getComponentFactoryRegistry();
    }
}

