/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.isis.applib.id.HasLogicalType;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ChoiceProviderAbstract;
import org.apache.wicket.model.IModel;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Select2MultiChoice;

public class Select2MultiChoiceExt
extends Select2MultiChoice<ObjectMemento>
implements HasLogicalType {
    private static final long serialVersionUID = 1L;
    private final LogicalType logicalType;
    private transient IModel<ObjectMemento> packingAdapterModel;
    private boolean workaround;

    public static Select2MultiChoiceExt create(String id, IModel<ArrayList<ObjectMemento>> modelObject, ScalarModel scalarModel, ChoiceProviderAbstract choiceProvider) {
        return new Select2MultiChoiceExt(id, (IModel<Collection<ObjectMemento>>)((IModel)_Casts.uncheckedCast(modelObject)), scalarModel, choiceProvider);
    }

    Select2MultiChoiceExt(String id, IModel<Collection<ObjectMemento>> model, ScalarModel scalarModel, ChoiceProviderAbstract choiceProvider) {
        super(id, model, (ChoiceProvider)choiceProvider);
        this.logicalType = scalarModel.getScalarTypeSpec().getLogicalType();
        this.getSettings().setCloseOnSelect(true);
        this.getSettings().setWidth("auto");
        this.getSettings().setDropdownAutoWidth(true);
        this.setOutputMarkupPlaceholderTag(true);
    }

    public ObjectMemento getPackedModelObject() {
        return ObjectMemento.pack((Collection)this.getModelObject(), (LogicalType)this.getLogicalType());
    }

    public ObjectMemento getPackedConvertedInput() {
        return ObjectMemento.pack((Collection)((Collection)this.getConvertedInput()), (LogicalType)this.getLogicalType());
    }

    public IModel<ObjectMemento> getPackingAdapterModel() {
        if (this.packingAdapterModel == null) {
            this.packingAdapterModel = this.createPackingAdapterModel();
        }
        return this.packingAdapterModel;
    }

    private IModel<ObjectMemento> createPackingAdapterModel() {
        final Select2MultiChoiceExt multi = this;
        return new IModel<ObjectMemento>(){
            private static final long serialVersionUID = 1L;
            final ObjectMemento memento;
            final IModel<Collection<ObjectMemento>> delegate;
            {
                this.delegate = multi.getModel();
                this.memento = ObjectMemento.pack((Collection)((Collection)this.delegate.getObject()), (LogicalType)multi.getLogicalType());
            }

            public ObjectMemento getObject() {
                return this.memento;
            }

            public void setObject(ObjectMemento memento) {
                this.delegate.setObject((Object)ObjectMemento.unpack((ObjectMemento)memento).orElse(null));
            }

            public void detach() {
            }
        };
    }

    public void updateModel() {
        this.workaround = true;
        super.updateModel();
        this.workaround = false;
    }

    public Collection<ObjectMemento> getModelObject() {
        Collection modelObj = (Collection)super.getModelObject();
        if (this.workaround) {
            return modelObj == null ? null : new ArrayList(modelObj);
        }
        return modelObj;
    }

    public LogicalType getLogicalType() {
        return this.logicalType;
    }
}

