/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.applib.id.HasLogicalType;
import org.apache.isis.commons.binding.Bindable;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.debug._XrayEvent;
import org.apache.isis.commons.internal.debug.xray.XrayUi;
import org.apache.isis.core.metamodel.interactions.managed.ManagedParameter;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.object.PackedManagedObject;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.util.PageParameterUtils;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelChangeDispatcher;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2ChoiceExt;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2MultiChoiceExt;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.springframework.lang.Nullable;
import org.wicketstuff.select2.JQuery;

class Select2OnSelect
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final ScalarModel scalarModel;
    private final ScalarModelChangeDispatcher select2ChangeDispatcher;

    public void renderHead(Component component, IHeaderResponse response) {
        for (Event event : Event.values()) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.execute((String)"$('#%s').on('select2:%s', function (e) {var data = e.params.data;Wicket.Ajax.get({'u': '%s&%s=' + data.id});});", (Object[])new Object[]{component.getMarkupId(), event.key(), this.getCallbackUrl(), event.key()})));
        }
    }

    public void onRequest() {
        this.updatePendingModels();
    }

    private void updatePendingModels() {
        PageParameterUtils.streamCurrentRequestParameters().forEach(pair -> Event.valueOf(pair).ifPresent(event -> {
            HasLogicalType component;
            ObjectMemento objectMementoFromEvent = ObjectMemento.destringFromUrlBase64((String)pair.getValue());
            if (this.getComponent() instanceof Select2MultiChoiceExt) {
                component = (Select2MultiChoiceExt)this.getComponent();
                switch (event) {
                    case SELECT: {
                        List<ObjectMemento> newSelection = this.copySelection((Collection<ObjectMemento>)component.getModelObject());
                        newSelection.add(objectMementoFromEvent);
                        component.setModelObject(newSelection);
                        this.updateReceiver().setValue((Object)this.demementify(newSelection));
                        break;
                    }
                    case UNSELECT: {
                        List<ObjectMemento> newSelection = this.copySelection((Collection<ObjectMemento>)component.getModelObject());
                        newSelection.remove(objectMementoFromEvent);
                        component.setModelObject(newSelection);
                        this.updateReceiver().setValue((Object)this.demementify(newSelection));
                        break;
                    }
                    case CLEAR: {
                        component.setModelObject(null);
                        this.clearUpdateReceiver();
                    }
                }
            } else if (this.getComponent() instanceof Select2ChoiceExt) {
                component = (Select2ChoiceExt)this.getComponent();
                switch (event) {
                    case SELECT: {
                        component.setModelObject((Object)objectMementoFromEvent);
                        this.updateReceiver().setValue((Object)this.demementify(objectMementoFromEvent));
                        break;
                    }
                    case UNSELECT: 
                    case CLEAR: {
                        component.clearInput();
                        this.clearUpdateReceiver();
                    }
                }
            } else {
                return;
            }
            if (XrayUi.isXrayEnabled()) {
                _XrayEvent.event((String)"Select2 event: %s %s", (Object[])new Object[]{event, objectMementoFromEvent.getBookmark()});
            }
            WebApplication app = (WebApplication)this.getComponent().getApplication();
            AjaxRequestTarget target = app.newAjaxRequestTarget(this.getComponent().getPage());
            this.select2ChangeDispatcher.notifyUpdate(target);
            RequestCycle requestCycle = RequestCycle.get();
            requestCycle.scheduleRequestHandlerAfterCurrent((IRequestHandler)target);
        }));
    }

    private List<ObjectMemento> copySelection(@Nullable Collection<ObjectMemento> outdatedSelection) {
        return outdatedSelection != null ? new ArrayList<ObjectMemento>(outdatedSelection) : new ArrayList(1);
    }

    private ManagedObject demementify(ObjectMemento memento) {
        return this.scalarModel.getObjectManager().demementify(memento);
    }

    private PackedManagedObject demementify(@NonNull List<ObjectMemento> mementos) {
        if (mementos == null) {
            throw new NullPointerException("mementos is marked non-null but is null");
        }
        return ManagedObject.packed((ObjectSpecification)this.elementSpec(), (Can)((Can)mementos.stream().map(this::demementify).collect(Can.toCan())));
    }

    @NonNull
    private Bindable<ManagedObject> updateReceiver() {
        Bindable updateReceiver = (Bindable)this.scalarModel.getSpecialization().fold(param -> param.getParameterNegotiationModel().getBindableParamValue(param.getParameterIndex()), prop -> prop.getPendingPropertyModel().getValue());
        return updateReceiver;
    }

    @NonNull
    private ObjectSpecification elementSpec() {
        ObjectSpecification updateReceiver = (ObjectSpecification)this.scalarModel.getSpecialization().fold(param -> param.getScalarTypeSpec(), prop -> prop.getScalarTypeSpec());
        return updateReceiver;
    }

    private void clearUpdateReceiver() {
        this.scalarModel.getSpecialization().accept(param -> ((ManagedParameter)param.getParameterNegotiationModel().getParamModels().getElseFail(param.getParameterIndex())).clear(), prop -> prop.getPendingPropertyModel().clear());
    }

    public Select2OnSelect(ScalarModel scalarModel, ScalarModelChangeDispatcher select2ChangeDispatcher) {
        this.scalarModel = scalarModel;
        this.select2ChangeDispatcher = select2ChangeDispatcher;
    }

    private static enum Event {
        SELECT,
        UNSELECT,
        CLEAR;


        String key() {
            return this.name().toLowerCase();
        }

        static Optional<Event> valueOf(INamedParameters.NamedPair pair) {
            for (Event event : Event.values()) {
                if (!event.name().equalsIgnoreCase(pair.getKey())) continue;
                return Optional.of(event);
            }
            return Optional.empty();
        }
    }
}

