/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers;

import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.metamodel.object.Bookmarkable;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.objectmanager.ObjectManager;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.util.Facets;
import org.apache.isis.viewer.commons.model.scalar.UiParameter;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ChoiceProviderAbstractForScalarModel;

public class ChoiceProviderForReferences
extends ChoiceProviderAbstractForScalarModel {
    private static final long serialVersionUID = 1L;
    private final ChoiceProviderSort choiceProviderSort;

    public ChoiceProviderForReferences(ScalarModel scalarModel) {
        super(scalarModel);
        this.choiceProviderSort = ChoiceProviderSort.valueOf(scalarModel);
    }

    @Override
    protected Can<ObjectMemento> query(String term) {
        switch (this.choiceProviderSort) {
            case CHOICES: {
                return super.filter(term, this.queryAll());
            }
            case AUTO_COMPLETE: {
                return this.queryWithAutoComplete(term);
            }
        }
        ObjectSpecification scalarTypeSpec = this.scalarModel().getScalarTypeSpec();
        Can autoCompleteAdapters = Facets.autoCompleteExecute((ObjectSpecification)scalarTypeSpec, (String)term);
        return autoCompleteAdapters.map(Bookmarkable::getMementoElseFail);
    }

    private Can<ObjectMemento> queryAll() {
        return this.scalarModel().getChoices().map(Bookmarkable::getMementoElseFail);
    }

    private Can<ObjectMemento> queryWithAutoComplete(String term) {
        ScalarModel scalarModel = this.scalarModel();
        Can pendingArgs = scalarModel.isParameter() ? ((UiParameter)scalarModel).getParameterNegotiationModel().getParamValues() : Can.empty();
        Can pendingArgMementos = pendingArgs.map(Bookmarkable::getMementoElseFail);
        if (scalarModel.isParameter()) {
            UiParameter paramModel = (UiParameter)scalarModel;
            paramModel.getParameterNegotiationModel().setParamValues(this.reconstructPendingArgs(paramModel, (Can<ObjectMemento>)pendingArgMementos));
        }
        return scalarModel.getAutoComplete(term).map(Bookmarkable::getMementoElseFail);
    }

    private Can<ManagedObject> reconstructPendingArgs(UiParameter parameterModel, Can<ObjectMemento> pendingArgMementos) {
        Can pendingArgsList = (Can)_NullSafe.stream(pendingArgMementos).map(arg_0 -> ((ObjectManager)this.getObjectManager()).demementify(arg_0)).collect(Can.toCan());
        return pendingArgsList;
    }

    static enum ChoiceProviderSort {
        NO_CHOICES,
        CHOICES,
        AUTO_COMPLETE,
        OBJECT_AUTO_COMPLETE;


        static ChoiceProviderSort valueOf(ScalarModel scalarModel) {
            if (scalarModel.hasChoices()) {
                return CHOICES;
            }
            if (scalarModel.hasAutoComplete()) {
                return AUTO_COMPLETE;
            }
            return OBJECT_AUTO_COMPLETE;
        }
    }
}

