/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.themepicker;

import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchThemeProvider;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.viewer.wicket.ui.components.widgets.themepicker.IsisWicketThemeSupport;
import org.apache.isis.viewer.wicket.ui.components.widgets.themepicker.ThemeProviderComposite;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.viewer.wicket.IsisWicketThemeSupportDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class IsisWicketThemeSupportDefault
implements IsisWicketThemeSupport {
    private static final Logger log = LogManager.getLogger(IsisWicketThemeSupportDefault.class);
    private final _Lazy<ThemeProviderComposite> themeProvider = _Lazy.of(this::createThemeProvider);
    @Inject
    private IsisConfiguration configuration;
    @Inject
    private ServiceRegistry serviceRegistry;

    @Override
    public ThemeProvider getThemeProvider() {
        return (ThemeProvider)this.themeProvider.get();
    }

    @Override
    public List<String> getEnabledThemeNames() {
        ThemeProviderComposite composite = (ThemeProviderComposite)this.themeProvider.get();
        List<String> allThemes = composite.availableNames();
        allThemes = this.filterThemes(allThemes);
        return allThemes;
    }

    private ThemeProviderComposite createThemeProvider() {
        Can providerBeans = this.serviceRegistry.select(ThemeProvider.class);
        if (providerBeans.isEmpty()) {
            return ThemeProviderComposite.of((Can<ThemeProvider>)Can.ofSingleton((Object)this.createFallbackThemeProvider()));
        }
        return ThemeProviderComposite.of((Can<ThemeProvider>)providerBeans);
    }

    private ThemeProvider createFallbackThemeProvider() {
        BootswatchTheme bootswatchTheme;
        String themeName = this.configuration.getViewer().getWicket().getThemes().getInitial();
        try {
            bootswatchTheme = BootswatchTheme.valueOf((String)themeName);
        }
        catch (Exception ex) {
            bootswatchTheme = BootswatchTheme.Flatly;
            log.warn("Did not recognise configured bootswatch theme '{}', defaulting to '{}'", (Object)themeName, (Object)bootswatchTheme);
        }
        return new BootswatchThemeProvider(bootswatchTheme);
    }

    private List<String> filterThemes(List<String> allThemes) {
        Set enabledThemesSet = _NullSafe.stream((Collection)this.configuration.getViewer().getWicket().getThemes().getEnabled()).collect(Collectors.toSet());
        List<String> enabledThemes = enabledThemesSet.size() > 0 ? allThemes.stream().filter(enabledThemesSet::contains).collect(Collectors.toList()) : allThemes;
        return enabledThemes;
    }
}

