/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.isis.applib.exceptions.UnrecoverableException;
import org.apache.isis.applib.services.error.Ticket;
import org.apache.isis.applib.services.exceprecog.Recognition;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;
import org.apache.isis.viewer.wicket.ui.errors.StackTraceDetail;

public class ExceptionModel
extends ModelAbstract<List<StackTraceDetail>> {
    private static final long serialVersionUID = 1L;
    private static final String MAIN_MESSAGE_IF_NOT_RECOGNIZED = "Sorry, an unexpected error occurred.";
    private List<StackTraceDetail> stackTraceDetailList;
    private List<List<StackTraceDetail>> stackTraceDetailLists;
    private boolean recognized;
    private boolean authorizationCause;
    private final String mainMessage;
    private Ticket ticket;

    public static ExceptionModel create(MetaModelContext commonContext, Optional<Recognition> recognition, Exception ex) {
        TranslationService translationService = commonContext.getTranslationService();
        Optional<String> recognizedMessage = recognition.map($ -> $.toMessage(translationService));
        return new ExceptionModel(commonContext, recognizedMessage.orElse(null), ex);
    }

    private ExceptionModel(MetaModelContext commonContext, String recognizedMessageIfAny, Exception ex) {
        super(commonContext);
        ObjectMember.AuthorizationException authorizationException = ExceptionModel.causalChainOf(ex, ObjectMember.AuthorizationException.class);
        if (authorizationException != null) {
            this.authorizationCause = true;
            this.mainMessage = authorizationException.getMessage();
        } else {
            this.authorizationCause = false;
            if (recognizedMessageIfAny != null) {
                this.recognized = true;
                this.mainMessage = recognizedMessageIfAny;
            } else {
                this.recognized = false;
                UnrecoverableException nonRecoverableException = _Exceptions.streamCausalChain((Throwable)ex).filter(UnrecoverableException.class::isInstance).map(UnrecoverableException.class::cast).findFirst().orElse(null);
                this.mainMessage = nonRecoverableException != null ? nonRecoverableException.getMessage() : MAIN_MESSAGE_IF_NOT_RECOGNIZED;
            }
        }
        this.stackTraceDetailList = ExceptionModel.asStackTrace(ex);
        this.stackTraceDetailLists = ExceptionModel.asStackTraces(ex);
    }

    protected List<StackTraceDetail> load() {
        return this.stackTraceDetailList;
    }

    private static <T extends Exception> T causalChainOf(Exception ex, Class<T> exType) {
        List causalChain = _Exceptions.getCausalChain((Throwable)ex);
        for (Throwable cause : causalChain) {
            if (!exType.isAssignableFrom(cause.getClass())) continue;
            return (T)((Exception)_Casts.uncheckedCast((Object)cause));
        }
        return null;
    }

    public void setObject(List<StackTraceDetail> stackTraceDetail) {
        if (stackTraceDetail == null) {
            return;
        }
        this.stackTraceDetailList = stackTraceDetail;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public boolean isRecognized() {
        return this.recognized;
    }

    public String getMainMessage() {
        return this.mainMessage;
    }

    public boolean isAuthorizationException() {
        return this.authorizationCause;
    }

    public List<StackTraceDetail> getStackTrace() {
        return this.stackTraceDetailList;
    }

    public List<List<StackTraceDetail>> getStackTraces() {
        return this.stackTraceDetailLists;
    }

    private static List<StackTraceDetail> asStackTrace(Throwable ex) {
        ArrayList stackTrace = _Lists.newArrayList();
        List causalChain = _Exceptions.getCausalChain((Throwable)ex);
        boolean firstTime = true;
        for (Throwable cause : causalChain) {
            if (!firstTime) {
                stackTrace.add(StackTraceDetail.spacer());
                stackTrace.add(StackTraceDetail.causedBy());
                stackTrace.add(StackTraceDetail.spacer());
            } else {
                firstTime = false;
            }
            ExceptionModel.append(cause, stackTrace);
        }
        return stackTrace;
    }

    private static List<List<StackTraceDetail>> asStackTraces(Throwable ex) {
        ArrayList stackTraces = _Lists.newArrayList();
        List causalChain = _Exceptions.getCausalChain((Throwable)ex);
        for (Throwable cause : causalChain) {
            ArrayList stackTrace = _Lists.newArrayList();
            ExceptionModel.append(cause, stackTrace);
            stackTraces.add(stackTrace);
        }
        return stackTraces;
    }

    private static void append(Throwable cause, List<StackTraceDetail> stackTrace) {
        stackTrace.add(StackTraceDetail.exceptionClassName(cause));
        stackTrace.add(StackTraceDetail.exceptionMessage(cause));
        for (StackTraceElement el : cause.getStackTrace()) {
            stackTrace.add(StackTraceDetail.element(el));
        }
    }
}

