/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages;

import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.wicket.model.models.HasCommonContext;
import org.apache.isis.viewer.wicket.model.util.WktContext;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.MetaDataHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class WebPageBase
extends WebPage
implements HasCommonContext {
    private static final long serialVersionUID = 1L;
    private transient MetaModelContext mmc;
    private transient PageClassRegistry pageClassRegistry;

    protected WebPageBase(PageParameters parameters) {
        super(parameters);
    }

    protected WebPageBase(IModel<?> model) {
        super(model);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.renderFavicon(response);
    }

    protected void renderFavicon(IHeaderResponse response) {
        this.getWicketViewerSettings().getApplication().getFaviconUrl().filter(_Strings::isNotEmpty).map(arg_0 -> ((WebAppContextPath)this.getWebAppContextPath()).prependContextPathIfLocal(arg_0)).ifPresent(faviconUrl -> response.render((HeaderItem)MetaDataHeaderItem.forLinkTag((String)"icon", (String)faviconUrl)));
    }

    public MetaModelContext getMetaModelContext() {
        this.mmc = WktContext.computeIfAbsent((MetaModelContext)this.mmc);
        return this.mmc;
    }

    public PageClassRegistry getPageClassRegistry() {
        this.pageClassRegistry = this.computeIfAbsent(PageClassRegistry.class, this.pageClassRegistry);
        return this.pageClassRegistry;
    }

    private <X> X computeIfAbsent(Class<X> type, X existingIfAny) {
        return (X)(existingIfAny != null ? existingIfAny : this.getMetaModelContext().lookupServiceElseFail(type));
    }
}

