/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.util.collections.MostRecentlyUsedMap;

public class AccountConfirmationMap
extends MostRecentlyUsedMap<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final MetaDataKey<AccountConfirmationMap> KEY = new MetaDataKey<AccountConfirmationMap>(){
        private static final long serialVersionUID = 1L;
    };
    private final Duration lifetime;

    public AccountConfirmationMap(int maxEntries, Duration lifetime) {
        super(maxEntries);
        this.lifetime = lifetime;
    }

    protected synchronized boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
        Value value;
        boolean removed = super.removeEldestEntry(eldest);
        if (!removed && (value = (Value)eldest.getValue()) != null && value.isExpired(this.lifetime)) {
            this.removedValue = value.email;
            removed = true;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String key, Object email) {
        Value oldValue;
        if (!(email instanceof String)) {
            throw new IllegalArgumentException(AccountConfirmationMap.class.getSimpleName() + " can store only instances of " + String.class.getSimpleName() + ": " + email);
        }
        Value value = new Value();
        value.creationTime = Instant.now();
        value.email = (String)email;
        AccountConfirmationMap accountConfirmationMap = this;
        synchronized (accountConfirmationMap) {
            oldValue = (Value)super.put((Object)key, (Object)value);
        }
        return oldValue != null ? oldValue.email : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object key) {
        Value value;
        String result = null;
        AccountConfirmationMap accountConfirmationMap = this;
        synchronized (accountConfirmationMap) {
            value = (Value)super.get(key);
        }
        if (value != null) {
            if (value.isExpired(this.lifetime)) {
                this.remove(key);
            } else {
                result = value.email;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(Object key) {
        Value removedValue;
        AccountConfirmationMap accountConfirmationMap = this;
        synchronized (accountConfirmationMap) {
            removedValue = (Value)super.remove(key);
        }
        return removedValue != null ? removedValue.email : null;
    }

    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    private static class Value {
        private String email;
        private Instant creationTime;

        private Value() {
        }

        public boolean isExpired(Duration lifetime) {
            Duration elapsedTime = Duration.between(this.creationTime, Instant.now());
            boolean isExpired = lifetime.minus(elapsedTime).isNegative();
            return isExpired;
        }
    }
}

