/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapJavascriptBehavior;
import de.agilecoders.wicket.core.markup.html.references.BootstrapJavaScriptReference;
import org.apache.isis.viewer.commons.applib.services.branding.BrandingUiModel;
import org.apache.isis.viewer.commons.applib.services.branding.BrandingUiService;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.components.widgets.navbar.BrandLogo;
import org.apache.isis.viewer.wicket.ui.components.widgets.navbar.BrandName;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionStackTracePanel;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.pages.WebPageBase;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.head.filter.HeaderResponseContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class AccountManagementPageAbstract
extends WebPageBase {
    private static final long serialVersionUID = 1L;
    private static final String ID_PAGE_TITLE = "pageTitle";
    private static final String ID_APPLICATION_NAME = "applicationName";
    private static final String ID_EXCEPTION_STACK_TRACE = "exceptionStackTrace";

    protected static ExceptionModel getAndClearExceptionModelIfAny() {
        ExceptionModel exceptionModel = PageAbstract.EXCEPTION.get();
        PageAbstract.EXCEPTION.remove();
        return exceptionModel;
    }

    protected AccountManagementPageAbstract(PageParameters parameters, ExceptionModel exceptionModel) {
        super(parameters);
        Class<? extends Page> pageClass = this.getPageClassRegistry().getPageClass(PageType.SIGN_IN);
        BookmarkablePageLink signInLink = new BookmarkablePageLink("signInLink", pageClass);
        signInLink.setAutoEnable(true);
        this.add(new Component[]{signInLink});
        this.addPageTitle();
        this.addApplicationName((MarkupContainer)signInLink);
        if (exceptionModel != null) {
            this.add(new Component[]{new ExceptionStackTracePanel(ID_EXCEPTION_STACK_TRACE, exceptionModel)});
        } else {
            this.add(new Component[]{new WebMarkupContainer(ID_EXCEPTION_STACK_TRACE).setVisible(false)});
        }
        this.add(new Component[]{new HeaderResponseContainer("footerJS", "footerJS")});
        BootstrapJavascriptBehavior.addTo((Component)this);
    }

    private void addPageTitle() {
        String applicationName = this.getWicketViewerSettings().getApplication().getName();
        Wkt.labelAdd((MarkupContainer)this, ID_PAGE_TITLE, applicationName);
    }

    private void addApplicationName(MarkupContainer parent) {
        BrandingUiModel branding = ((BrandingUiService)super.getMetaModelContext().lookupServiceElseFail(BrandingUiService.class)).getSignInBranding();
        BrandLogo brandLogo = new BrandLogo("brandLogo", branding);
        BrandName brandName = new BrandName(ID_APPLICATION_NAME, branding);
        parent.add(new Component[]{brandName, brandLogo});
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference())));
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapJavaScriptReference.instance())));
        this.getWicketViewerSettings().getApplication().getCss().ifPresent(css -> response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)css)));
        this.getWicketViewerSettings().getApplication().getJs().ifPresent(js -> response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)js)));
    }
}

