/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt;

import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.wicket.ui.validation.ValidatorBase;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;

public class EmailAvailableValidator
extends ValidatorBase<String> {
    private static final long serialVersionUID = 1L;
    private final boolean emailExists;
    private final String resourceKey;

    public static EmailAvailableValidator exists(MetaModelContext commonContext) {
        return new EmailAvailableValidator(commonContext, true, "noSuchUserByEmail");
    }

    public static EmailAvailableValidator doesntExist(MetaModelContext commonContext) {
        return new EmailAvailableValidator(commonContext, false, "emailIsNotAvailable");
    }

    private EmailAvailableValidator(MetaModelContext commonContext, boolean emailExists, String resourceKey) {
        super(commonContext);
        this.emailExists = emailExists;
        this.resourceKey = resourceKey;
    }

    public void validate(IValidatable<String> validatable) {
        UserRegistrationService userRegistrationService = (UserRegistrationService)super.getMetaModelContext().lookupServiceElseFail(UserRegistrationService.class);
        InteractionService interactionService = (InteractionService)super.getMetaModelContext().lookupServiceElseFail(InteractionService.class);
        interactionService.runAnonymous(() -> {
            String email = (String)validatable.getValue();
            boolean emailExists1 = userRegistrationService.emailExists(email);
            if (emailExists1 != this.emailExists) {
                validatable.error((IValidationError)new ValidationError().addKey(this.resourceKey));
            }
        });
    }
}

