/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt;

import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.wicket.ui.validation.ValidatorBase;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;

public class UsernameAvailableValidator
extends ValidatorBase<String> {
    private static final long serialVersionUID = 1L;

    public static UsernameAvailableValidator instance(MetaModelContext commonContext) {
        return new UsernameAvailableValidator(commonContext);
    }

    private UsernameAvailableValidator(MetaModelContext commonContext) {
        super(commonContext);
    }

    public void validate(IValidatable<String> validatable) {
        UserRegistrationService userRegistrationService = (UserRegistrationService)super.getMetaModelContext().lookupServiceElseFail(UserRegistrationService.class);
        InteractionService interactionService = (InteractionService)super.getMetaModelContext().lookupServiceElseFail(InteractionService.class);
        interactionService.runAnonymous(() -> {
            String username = (String)validatable.getValue();
            boolean usernameExists = userRegistrationService.usernameExists(username);
            if (usernameExists) {
                validatable.error((IValidationError)new ValidationError().addKey("usernameIsNotAvailable"));
            }
        });
    }
}

