/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt.password_reset;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.isis.applib.services.userreg.events.PasswordResetEvent;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.EmailAvailableValidator;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.SuccessFeedbackCookieManager;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.password_reset.EmailAddressValidator;
import org.apache.isis.viewer.wicket.ui.panels.PanelBase;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;

public class PasswordResetEmailPanel
extends PanelBase<Void> {
    private static final long serialVersionUID = 1L;

    public PasswordResetEmailPanel(String id) {
        super(id);
        StatelessForm form = new StatelessForm("signUpForm");
        this.addOrReplace(new Component[]{form});
        final RequiredTextField emailField = new RequiredTextField("email", (IModel)Model.of((Serializable)((Object)"")));
        emailField.setLabel((IModel)new ResourceModel("emailLabel"));
        emailField.add((IValidator)EmailAddressValidator.getInstance());
        emailField.add((IValidator)EmailAvailableValidator.exists(this.getMetaModelContext()));
        FormGroup formGroup = new FormGroup("formGroup", (FormComponent<?>)emailField);
        form.add(new Component[]{formGroup});
        formGroup.add(new Component[]{emailField});
        Button signUpButton = new Button("passwordResetSubmit"){
            private static final long serialVersionUID = 1L;
            private final RequiredTextField<String> _emailField;
            {
                super(id);
                this._emailField = emailField;
            }

            public void onSubmit() {
                super.onSubmit();
                PasswordResetEmailPanel.this.passwordResetSubmit(this._emailField);
            }
        };
        form.add(new Component[]{signUpButton});
    }

    private void passwordResetSubmit(RequiredTextField<String> emailField) {
        String email = (String)emailField.getModelObject();
        String confirmationUrl = super.getEmailVerificationUrlService().createVerificationUrl(PageType.PASSWORD_RESET, email);
        PasswordResetEvent passwordResetEvent = new PasswordResetEvent(email, confirmationUrl, this.getWicketViewerSettings().getApplication().getName());
        boolean emailSent = super.getEmailNotificationService().send(passwordResetEvent);
        if (emailSent) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("email", email);
            IModel model = Model.ofMap(map);
            String emailSentMessage = this.getString("emailSentMessage", model);
            SuccessFeedbackCookieManager.storeSuccessFeedback(emailSentMessage);
            super.getPageNavigationService().navigateTo(PageType.SIGN_IN);
        }
    }
}

