/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt.register;

import javax.inject.Inject;
import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.applib.services.userreg.UserDetails;
import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.AccountConfirmationMap;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.UsernameAvailableValidator;
import org.apache.isis.viewer.wicket.ui.panels.PanelBase;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.EqualPasswordInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;

public abstract class RegisterPanel
extends PanelBase<UserDetails> {
    private static final long serialVersionUID = 1L;
    protected static final String ID_REGISTER_FORM = "registerForm";
    private static final String ID_USERNAME = "username";
    private static final String ID_USERNAME_FORM_GROUP = "usernameFormGroup";
    private static final String ID_PASSWORD = "password";
    private static final String ID_PASSWORD_FORM_GROUP = "passwordFormGroup";
    private static final String ID_CONFIRM_PASSWORD = "confirmPassword";
    private static final String ID_CONFIRM_PASSWORD_FORM_GROUP = "confirmPasswordFormGroup";
    private static final String ID_EMAIL = "email";
    private final UserDetails userDetails;
    private final String uuid;

    public RegisterPanel(String id, UserDetails userDetails, String uuid) {
        super(id);
        this.userDetails = userDetails;
        this.uuid = uuid;
    }

    protected void onInitialize() {
        super.onInitialize();
        RegisterForm registerForm = new RegisterForm(ID_REGISTER_FORM, this.uuid, this.userDetails);
        this.add(new Component[]{registerForm});
        MarkupContainer username = this.newUsernameField();
        MarkupContainer password = this.newPasswordField();
        MarkupContainer confirmPassword = this.newConfirmPasswordField();
        registerForm.add(this.newEqualPasswordInputValidator(password, confirmPassword));
        TextField<String> emailField = this.newEmailField(this.userDetails);
        registerForm.add(new Component[]{username, password, confirmPassword, emailField});
        registerForm.add(new Component[]{this.newExtraFieldsContainer("extraFieldsContainer")});
    }

    protected abstract MarkupContainer newExtraFieldsContainer(String var1);

    private IFormValidator newEqualPasswordInputValidator(MarkupContainer password, MarkupContainer confirmPassword) {
        FormComponent passwordField = (FormComponent)password.get(ID_PASSWORD);
        FormComponent confirmPasswordField = (FormComponent)confirmPassword.get(ID_CONFIRM_PASSWORD);
        return new EqualPasswordInputValidator(passwordField, confirmPasswordField);
    }

    protected TextField<String> newEmailField(final UserDetails userDetails) {
        TextField emailField = new TextField(ID_EMAIL, (IModel)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return userDetails.getEmailAddress();
            }
        });
        return emailField;
    }

    protected MarkupContainer newConfirmPasswordField() {
        PasswordTextField confirmPassword = new PasswordTextField(ID_CONFIRM_PASSWORD);
        confirmPassword.setLabel((IModel)new ResourceModel("confirmPasswordLabel"));
        FormGroup confirmPasswordFormGroup = new FormGroup(ID_CONFIRM_PASSWORD_FORM_GROUP, (FormComponent<?>)confirmPassword);
        confirmPasswordFormGroup.add(new Component[]{confirmPassword});
        return confirmPasswordFormGroup;
    }

    protected MarkupContainer newPasswordField() {
        PasswordTextField password = new PasswordTextField(ID_PASSWORD);
        password.setLabel((IModel)new ResourceModel("passwordLabel"));
        FormGroup passwordFormGroup = new FormGroup(ID_PASSWORD_FORM_GROUP, (FormComponent<?>)password);
        passwordFormGroup.add(new Component[]{password});
        return passwordFormGroup;
    }

    protected MarkupContainer newUsernameField() {
        RequiredTextField username = new RequiredTextField(ID_USERNAME);
        username.add((IValidator)UsernameAvailableValidator.instance(super.getMetaModelContext()));
        FormGroup usernameFormGroup = new FormGroup(ID_USERNAME_FORM_GROUP, (FormComponent<?>)username);
        usernameFormGroup.add(new Component[]{username});
        return usernameFormGroup;
    }

    private class RegisterForm
    extends StatelessForm<UserDetails> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient UserRegistrationService userRegistrationService;
        @Inject
        private transient TransactionService transactionService;
        @Inject
        private transient InteractionService interactionService;
        private final String uuid;

        public RegisterForm(String id, String uuid, UserDetails userDetails) {
            super(id, (IModel)new CompoundPropertyModel((Object)userDetails));
            this.uuid = uuid;
            String email = this.getEmail();
            userDetails.setEmailAddress(email);
        }

        public final void onSubmit() {
            UserDetails userDetails = (UserDetails)this.getModelObject();
            this.interactionService.runAnonymous(() -> this.transactionService.runWithinCurrentTransactionElseCreateNew(() -> {
                this.userRegistrationService.registerUser(userDetails);
                this.removeAccountConfirmation();
            }));
            this.signIn(userDetails.getUsername(), userDetails.getPassword());
            this.setResponsePage(this.getApplication().getHomePage());
        }

        private boolean signIn(String username, String password) {
            return AuthenticatedWebSession.get().signIn(username, password);
        }

        private String getEmail() {
            AccountConfirmationMap accountConfirmationMap = (AccountConfirmationMap)((Object)this.getApplication().getMetaData(AccountConfirmationMap.KEY));
            return accountConfirmationMap.get(this.uuid);
        }

        private void removeAccountConfirmation() {
            AccountConfirmationMap accountConfirmationMap = (AccountConfirmationMap)((Object)this.getApplication().getMetaData(AccountConfirmationMap.KEY));
            accountConfirmationMap.remove(this.uuid);
        }
    }
}

