/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.common.datatables;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class DatatablesJavaScriptResourceReferenceInit
extends JavaScriptContentHeaderItem {
    private static final long serialVersionUID = 1L;
    private static final String ID = "dataTablesInit";
    private static DatatablesJavaScriptResourceReferenceInit instance = null;

    public static final DatatablesJavaScriptResourceReferenceInit instance(IsisConfiguration configuration) {
        if (instance == null) {
            String javascript = DatatablesJavaScriptResourceReferenceInit.readResource(configuration);
            instance = new DatatablesJavaScriptResourceReferenceInit(javascript, ID);
        }
        return instance;
    }

    private DatatablesJavaScriptResourceReferenceInit(CharSequence javaScript, String id) {
        super(javaScript, id);
    }

    private static String readResource(IsisConfiguration configuration) {
        String options = configuration.getViewer().getWicket().getTable().getDecoration().getDataTablesNet().getOptions().orElse("");
        return DatatablesJavaScriptResourceReferenceInit.readScript().replace("$PLACEHOLDER$", options);
    }

    private static String readScript() {
        return DatatablesJavaScriptResourceReferenceInit.asString((Resource)new ClassPathResource("dataTables.init.js.template", DatatablesJavaScriptResourceReferenceInit.class));
    }

    private static String asString(Resource resource) {
        String string;
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
        try {
            string = FileCopyUtils.copyToString((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "";
            }
        }
        ((Reader)reader).close();
        return string;
    }
}

