/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.home;

import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.core.metamodel.object.ManagedObjects;
import org.apache.isis.viewer.commons.model.components.UiComponentType;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@AuthorizeInstantiation(value={"org.apache.isis.security.AUTHORIZED_USER_ROLE"})
public class HomePage
extends PageAbstract {
    private static final long serialVersionUID = 1L;

    public HomePage(PageParameters parameters) {
        super(parameters, null, new UiComponentType[0]);
        this.addChildComponents(this.themeDiv, null);
        this.buildGui();
        this.addBookmarkedPages(this.themeDiv);
    }

    private void buildGui() {
        ManagedObject homePageAdapter;
        if (super.getPageParameters() == null) {
            ((MessageService)super.getMetaModelContext().lookupServiceElseFail(MessageService.class)).informUser("Page timeout");
        }
        if (ManagedObjects.isSpecified((ManagedObject)(homePageAdapter = super.getMetaModelContext().getHomePageAdapter()))) {
            RequestCycle requestCycle = RequestCycle.get();
            EntityPage page = EntityPage.forAdapter(this.getMetaModelContext(), homePageAdapter);
            requestCycle.setResponsePage((IRequestablePage)page);
        } else {
            WktComponents.permanentlyHide(this.themeDiv, UiComponentType.ACTION_PROMPT);
            this.getComponentFactoryRegistry().addOrReplaceComponent(this.themeDiv, UiComponentType.WELCOME, null);
        }
        BreadcrumbModelProvider breadcrumbModelProvider = (BreadcrumbModelProvider)this.getSession();
        BreadcrumbModel breadcrumbModel = breadcrumbModelProvider.getBreadcrumbModel();
        breadcrumbModel.visitedHomePage();
    }
}

