/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.login;

import javax.inject.Inject;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.AccountManagementPageAbstract;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.SuccessFeedbackCookieManager;
import org.apache.isis.viewer.wicket.ui.pages.login.IsisSignInPanel;
import org.apache.isis.viewer.wicket.ui.pages.login.SignInPanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class WicketSignInPage
extends AccountManagementPageAbstract {
    private static final long serialVersionUID = 1L;
    @Inject
    private PageNavigationService pageNavigationService;

    public WicketSignInPage(PageParameters parameters) {
        this(parameters, WicketSignInPage.getAndClearExceptionModelIfAny());
    }

    public WicketSignInPage(PageParameters parameters, ExceptionModel exceptionModel) {
        super(parameters, exceptionModel);
        if (AuthenticatedWebSession.exists() && AuthenticatedWebSession.get().isSignedIn()) {
            this.pageNavigationService.restartAt(PageType.HOME);
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createSignInPanel()});
        SuccessFeedbackCookieManager.drainSuccessFeedback(arg_0 -> ((WicketSignInPage)this).success(arg_0));
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SignInPanelAbstract.getJsForTimezoneSelectDefault()));
    }

    protected IsisSignInPanel createSignInPanel() {
        boolean rememberMeSuppress;
        boolean suppressRememberMe = rememberMeSuppress = this.getWicketViewerSettings().getRememberMe().isSuppress();
        boolean suppressSignUpLink = this.getWicketViewerSettings().isSuppressSignUp();
        boolean suppressPasswordResetLink = this.getWicketViewerSettings().isSuppressPasswordReset();
        boolean clearOriginalDestination = this.getWicketViewerSettings().isClearOriginalDestination();
        boolean rememberMe = !suppressRememberMe;
        boolean signUpLink = !suppressSignUpLink;
        boolean passwordReset = !suppressPasswordResetLink;
        boolean continueToOriginalDestination = !clearOriginalDestination;
        IsisSignInPanel signInPanel = new IsisSignInPanel("signInPanel", rememberMe, signUpLink, passwordReset, continueToOriginalDestination);
        return signInPanel;
    }
}

