/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.mmverror;

import de.agilecoders.wicket.core.markup.html.references.BootstrapJavaScriptReference;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.viewer.wicket.ui.pages.WebPageBase;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class MmvErrorPage
extends WebPageBase {
    private static final long serialVersionUID = 1L;
    private static final String ID_PAGE_TITLE = "pageTitle";
    private static final String ID_APPLICATION_NAME = "applicationName";
    private static final String ID_ERROR = "error";
    private static final String ID_ERROR_MESSAGE = "errorMessage";

    public MmvErrorPage(Collection<String> validationErrors) {
        this((IModel<List<String>>)Model.ofList((List)_Lists.newArrayList(validationErrors)));
    }

    public MmvErrorPage(IModel<List<String>> model) {
        super(model);
        this.addPageTitle();
        this.addApplicationName();
        this.addValidationErrors();
    }

    private IModel<List<String>> getModel() {
        return this.getDefaultModel();
    }

    private void addPageTitle() {
        Wkt.labelAdd((MarkupContainer)this, ID_PAGE_TITLE, this.getWicketViewerSettings().getApplication().getName());
    }

    private void addApplicationName() {
        Wkt.labelAdd((MarkupContainer)this, ID_APPLICATION_NAME, this.getWicketViewerSettings().getApplication().getName());
    }

    private void addValidationErrors() {
        Wkt.listViewAdd((MarkupContainer)this, ID_ERROR, this.getModel(), (SerializableConsumer & Serializable)item -> {
            String validationError = (String)item.getModelObject();
            Wkt.labelAdd((MarkupContainer)item, ID_ERROR_MESSAGE, validationError);
        });
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference())));
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapJavaScriptReference.instance())));
        this.getWicketViewerSettings().getApplication().getCss().ifPresent(css -> response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)css)));
        this.getWicketViewerSettings().getApplication().getJs().ifPresent(js -> response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)js)));
    }

    public boolean isErrorPage() {
        return true;
    }
}

