/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import java.io.Serializable;
import org.apache.isis.core.metamodel.object.ManagedObject;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.FormFeedbackPanel;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.isis.viewer.wicket.ui.panels.FormAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;

public abstract class OkCancelForm<T extends IModel<ManagedObject>>
extends FormAbstract<ManagedObject> {
    private static final long serialVersionUID = 1L;
    private static final String ID_OK_BUTTON = "okButton";
    public static final String ID_CANCEL_BUTTON = "cancelButton";
    private static final String ID_FEEDBACK = "feedback";
    protected final AjaxButton okButton = Wkt.buttonAddOk((MarkupContainer)this, "okButton", (IModel<String>)(IModel & Serializable)() -> this.translate("OK"), this.getWicketViewerSettings(), (SerializableBiConsumer<AjaxButton, AjaxRequestTarget>)((SerializableBiConsumer & Serializable)this::onOkSubmitted));
    protected final AjaxButton cancelButton = Wkt.buttonAdd((MarkupContainer)this, "cancelButton", (IModel<String>)(IModel & Serializable)() -> this.translate("Cancel"), (SerializableBiConsumer<AjaxButton, AjaxRequestTarget>)(SerializableBiConsumer & Serializable)(button, target) -> this.onCancelSubmitted((AjaxRequestTarget)target));

    protected OkCancelForm(String id, IModel<ManagedObject> model) {
        super(id, model);
        this.configureOkButton(this.okButton);
        this.configureCancelButton(this.cancelButton);
        this.setDefaultButton((IFormSubmittingComponent)this.okButton);
        Wkt.add((MarkupContainer)this, new FormFeedbackPanel(ID_FEEDBACK));
        this.setOutputMarkupId(true);
    }

    protected abstract void onOkSubmitted(AjaxButton var1, AjaxRequestTarget var2);

    protected abstract void onCancelSubmitted(AjaxRequestTarget var1);

    protected void configureOkButton(AjaxButton okButton) {
        okButton.add(new Behavior[]{new JGrowlBehaviour(this.getMetaModelContext())});
    }

    protected void configureCancelButton(AjaxButton cancelButton) {
        cancelButton.setDefaultFormProcessing(false);
    }

    protected final void appendDefaultButtonField() {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append("<div style=\"width:0px;height:0px;position:absolute;left:-100px;top:-100px;overflow:hidden\">");
        buffer.append("<input type=\"text\" tabindex=\"-1\" autocomplete=\"off\"/>");
        AjaxButton submittingComponent = this.defaultSubmittingComponent();
        buffer.append("<input type=\"submit\" tabindex=\"-1\" name=\"");
        buffer.append(this.defaultSubmittingComponent().getInputName());
        buffer.append("\" onclick=\" var b=document.getElementById('");
        buffer.append(submittingComponent.getMarkupId());
        buffer.append("'); if (b!=null&amp;&amp;b.onclick!=null&amp;&amp;typeof(b.onclick) != 'undefined') {  var r = Wicket.bind(b.onclick, b)(); if (r != false) b.click(); } else { b.click(); };  return false;\" ");
        buffer.append(" />");
        buffer.append("</div>");
        this.getResponse().write((CharSequence)buffer);
    }

    private AjaxButton defaultSubmittingComponent() {
        return this.okButton;
    }
}

