/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import java.util.function.Supplier;
import org.apache.isis.applib.services.i18n.LanguageProvider;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.commons.applib.services.header.HeaderUiModel;
import org.apache.isis.viewer.commons.applib.services.header.HeaderUiService;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.HasCommonContext;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.model.util.WktContext;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.HasComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.components.tree.themes.TreeThemeProvider;
import org.apache.isis.viewer.wicket.ui.components.tree.themes.TreeThemeProviderDefault;
import org.apache.isis.viewer.wicket.ui.pages.EmailVerificationUrlService;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public class PanelBase<T>
extends GenericPanel<T>
implements HasCommonContext {
    private static final long serialVersionUID = 1L;
    private transient MetaModelContext mmc;
    private transient PageClassRegistry pageClassRegistry;
    private transient ImageResourceCache imageCache;
    private transient LanguageProvider localeProvider;
    private transient TreeThemeProvider treeThemeProvider;
    private transient EmailNotificationService emailNotificationService;
    private transient EmailVerificationUrlService emailVerificationUrlService;
    private transient PageNavigationService pageNavigationService;
    private transient HeaderUiService headerUiService;

    protected PanelBase(String id) {
        this(id, null);
    }

    public PanelBase(String id, @Nullable IModel<T> model) {
        super(id, model);
    }

    public MetaModelContext getMetaModelContext() {
        this.mmc = WktContext.computeIfAbsent((MetaModelContext)this.mmc);
        return this.mmc;
    }

    public PageClassRegistry getPageClassRegistry() {
        this.pageClassRegistry = this.computeIfAbsent(PageClassRegistry.class, this.pageClassRegistry);
        return this.pageClassRegistry;
    }

    public ImageResourceCache getImageResourceCache() {
        this.imageCache = this.computeIfAbsent(ImageResourceCache.class, this.imageCache);
        return this.imageCache;
    }

    public LanguageProvider getLanguageProvider() {
        this.localeProvider = this.computeIfAbsent(LanguageProvider.class, this.localeProvider);
        return this.localeProvider;
    }

    protected TreeThemeProvider getTreeThemeProvider() {
        this.treeThemeProvider = this.computeIfAbsentOrFallback(TreeThemeProvider.class, this.treeThemeProvider, TreeThemeProviderDefault::new);
        return this.treeThemeProvider;
    }

    protected EmailNotificationService getEmailNotificationService() {
        this.emailNotificationService = this.computeIfAbsent(EmailNotificationService.class, this.emailNotificationService);
        return this.emailNotificationService;
    }

    protected EmailVerificationUrlService getEmailVerificationUrlService() {
        this.emailVerificationUrlService = this.computeIfAbsent(EmailVerificationUrlService.class, this.emailVerificationUrlService);
        return this.emailVerificationUrlService;
    }

    protected PageNavigationService getPageNavigationService() {
        this.pageNavigationService = this.computeIfAbsent(PageNavigationService.class, this.pageNavigationService);
        return this.pageNavigationService;
    }

    protected HeaderUiModel getHeaderModel() {
        this.headerUiService = this.computeIfAbsent(HeaderUiService.class, this.headerUiService);
        return this.headerUiService.getHeader();
    }

    public UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this);
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((HasComponentFactoryRegistry)this.getApplication()).getComponentFactoryRegistry();
    }

    private <X> X computeIfAbsent(Class<X> type, X existingIfAny) {
        return (X)(existingIfAny != null ? existingIfAny : this.lookupServiceElseFail(type));
    }

    private <X> X computeIfAbsentOrFallback(Class<X> type, X existingIfAny, Supplier<X> fallback) {
        return (X)(existingIfAny != null ? existingIfAny : this.lookupServiceElseFallback(type, fallback));
    }
}

