/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import org.apache.isis.commons.internal.base._Strings;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public final class PanelUtil {
    private PanelUtil() {
    }

    public static void renderHead(IHeaderResponse response, Class<?> cls) {
        CssResourceReference cssResourceReference = PanelUtil.cssResourceReferenceFor(cls);
        if (cssResourceReference == null) {
            return;
        }
        CssReferenceHeaderItem forReference = CssHeaderItem.forReference((ResourceReference)cssResourceReference);
        response.render((HeaderItem)forReference);
    }

    public static CssResourceReference cssResourceReferenceFor(Class<?> cls) {
        return PanelUtil.cssResourceReferenceFor(cls, null);
    }

    public static CssResourceReference cssResourceReferenceFor(Class<?> cls, String suffix) {
        String url = PanelUtil.cssFor(cls, suffix);
        if (url == null) {
            return null;
        }
        return new CssResourceReference(cls, url);
    }

    private static String cssFor(Class<?> cls, String suffix) {
        if (cls == null) {
            return null;
        }
        String simpleName = cls.getSimpleName();
        if (_Strings.isNullOrEmpty((CharSequence)simpleName)) {
            return null;
        }
        Object string = suffix != null ? "-" + suffix : "";
        return simpleName + (String)string + ".css";
    }

    public static void disableBeforeReenableOnComplete(AjaxRequestAttributes attributes, Component ajaxButtonOrLink) {
        attributes.getAjaxCallListeners().add(new AjaxCallListener().onBefore((CharSequence)("$('#" + ajaxButtonOrLink.getMarkupId() + "').prop('disabled',true);")).onComplete((CharSequence)("$('#" + ajaxButtonOrLink.getMarkupId() + "').prop('disabled',false);")));
    }
}

