/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameRemover;
import java.util.EnumSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public final class BootstrapConstants {
    private BootstrapConstants() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum ButtonSemantics {
        PRIMARY,
        SECONDARY,
        SUCCESS,
        DANGER,
        WARNING,
        INFO,
        LIGHT,
        DARK;


        public String buttonDefaultCss() {
            return "btn-" + this.name().toLowerCase();
        }

        public String buttonOutlineCss() {
            return "btn-outline-" + this.name().toLowerCase();
        }

        public String fullButtonCss(@NonNull EnumSet<ButtonModifier> modifiers) {
            if (modifiers == null) {
                throw new NullPointerException("modifiers is marked non-null but is null");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("btn ");
            if (modifiers.contains((Object)ButtonModifier.OUTLINE)) {
                sb.append(this.buttonDefaultCss());
            } else {
                sb.append(this.buttonOutlineCss());
            }
            if (modifiers.contains((Object)ButtonModifier.SMALL)) {
                sb.append(" btn-sm");
            }
            return sb.toString();
        }

        public String fullButtonCss() {
            return this.fullButtonCss(EnumSet.noneOf(ButtonModifier.class));
        }

        private static Stream<String> streamAllSemanticsNamesAndVariants() {
            return Stream.of(ButtonSemantics.values()).flatMap(bs -> Stream.of(bs.buttonDefaultCss(), bs.buttonOutlineCss()));
        }

        public static CssClassNameRemover createButtonSemanticsRemover() {
            return new CssClassNameRemover(ButtonSemantics.streamAllSemanticsNamesAndVariants().collect(Collectors.toList()));
        }
    }

    public static enum ButtonModifier {
        SMALL,
        OUTLINE;

    }
}

