/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxX;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxXConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.JQuery;
import de.agilecoders.wicket.jquery.Key;
import java.io.Serializable;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.isis.applib.Identifier;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.debug._Probe;
import org.apache.isis.commons.internal.functions._Functions;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.viewer.commons.model.components.UiString;
import org.apache.isis.viewer.wicket.model.hints.IsisActionCompletedEvent;
import org.apache.isis.viewer.wicket.model.hints.IsisEnvelopeEvent;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupComponent;
import org.apache.isis.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.ui.util.ResourceLinkVolatile;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.StringValidator;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableBooleanSupplier;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.springframework.lang.Nullable;

public final class Wkt {
    static final String fragment_prompt_checkboxYes = "<label class=\"fs-4\" style=\"color: green;\"><i class=\"fa-regular fa-check-square\"></i></label>";
    static final String fragment_prompt_checkboxNo = "<label class=\"fs-4\"><i class=\"fa-regular fa-square\"></i></label>";
    static final String fragment_prompt_checkboxIntermediate = "<label class=\"fs-4\" style=\"color: silver;\"><i class=\"fa-regular fa-square-minus\"></i></label>";

    public static <T extends Component> T add(MarkupContainer container, T component) {
        container.addOrReplace(new Component[]{component});
        return component;
    }

    public static <T extends Behavior> T add(Component component, T behavior) {
        component.add(new Behavior[]{behavior});
        return behavior;
    }

    public static <T extends Component> T ajaxEnable(T component) {
        component.setOutputMarkupId(true);
        return component;
    }

    public static <T extends Component> T attributeReplace(@Nullable T component, @Nullable String attributeName, @Nullable String attributeValue) {
        if (component == null || _Strings.isEmpty((CharSequence)attributeName)) {
            return component;
        }
        if (_Strings.isEmpty((CharSequence)attributeValue)) {
            component.add(new Behavior[]{AttributeModifier.remove((String)attributeName)});
            return component;
        }
        component.add(new Behavior[]{AttributeModifier.replace((String)attributeName, (Serializable)((Object)attributeValue))});
        return component;
    }

    public static <T extends Component> T attributeReplace(@Nullable T component, @Nullable String attributeName, @Nullable Integer attributeValue) {
        return Wkt.attributeReplace(component, attributeName, attributeValue != null ? "" + attributeValue : null);
    }

    public static Behavior behaviorOnClick(final SerializableConsumer<AjaxRequestTarget> onClick) {
        return new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User clicking on an editable Property (to start inline editing)or an Action (to enter param negotiaton or directly execute the Action).");
                onClick.accept((Object)target);
            }
        };
    }

    public static Behavior behaviorFireOnEscapeKey(final SerializableConsumer<AjaxRequestTarget> onRespond) {
        return new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;
            private static final String PRE_JS = "$(document).ready( function() { \n  $(document).bind('keyup', function(evt) { \n    if (evt.keyCode == 27) { \n";
            private static final String POST_JS = "      evt.preventDefault(); \n       } \n  }); \n});";

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                String javascript = PRE_JS + this.getCallbackScript() + POST_JS;
                response.render((HeaderItem)new JavaScriptContentHeaderItem((CharSequence)javascript, null));
            }

            protected void respond(AjaxRequestTarget target) {
                onRespond.accept((Object)target);
            }
        };
    }

    public static Behavior behaviorReplaceDisabledTagWithReadonlyTag() {
        return new ReplaceDisabledTagWithReadonlyTagBehavior();
    }

    public static Behavior behaviorConfirm(ConfirmationConfig config) {
        return new ConfirmationBehavior(config);
    }

    public static Behavior behaviorAddOnClick(Component component, SerializableConsumer<AjaxRequestTarget> onClick) {
        return Wkt.add(component, Wkt.behaviorOnClick(onClick));
    }

    public static Behavior behaviorAddFireOnEscapeKey(Component component, SerializableConsumer<AjaxRequestTarget> onRespond) {
        return Wkt.add(component, Wkt.behaviorFireOnEscapeKey(onRespond));
    }

    public static Behavior behaviorAddConfirm(Component component, ConfirmationConfig config) {
        return Wkt.add(component, Wkt.behaviorConfirm(config));
    }

    public static void behaviorAddReplaceDisabledTagWithReadonlyTag(@Nullable Component component) {
        if (component == null) {
            return;
        }
        if (component.getBehaviors(ReplaceDisabledTagWithReadonlyTagBehavior.class).isEmpty()) {
            component.add(new Behavior[]{new ReplaceDisabledTagWithReadonlyTagBehavior()});
        }
    }

    public static BookmarkablePageLink<Void> bookmarkablePageLinkWithVisibility(String id, Class<? extends Page> pageClass, PageParameters pageParameters, final SerializableBooleanSupplier dynamicVisibility) {
        return new BookmarkablePageLink<Void>(id, pageClass, pageParameters){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return dynamicVisibility.getAsBoolean();
            }

            protected CharSequence getOnClickScript(CharSequence url) {
                return "var win = this.ownerDocument.defaultView || this.ownerDocument.parentWindow; if (win == window) {  if(event.ctrlKey) {    window.open('" + url + "', '_blank').focus();  } else {    window.location.href='" + url + "';  }}return false";
            }
        };
    }

    public static AjaxButton button(String id, IModel<String> labelModel, final SerializableBiConsumer<AjaxButton, AjaxRequestTarget> onClick) {
        return new AjaxButton(id, labelModel){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                onClick.accept((Object)this, (Object)target);
            }
        };
    }

    public static AjaxButton buttonOk(String id, IModel<String> labelModel, IsisConfiguration.Viewer.Wicket settings, final SerializableBiConsumer<AjaxButton, AjaxRequestTarget> onClick) {
        final boolean isPreventDoubleClickForFormSubmit = settings.isPreventDoubleClickForFormSubmit();
        return settings.isUseIndicatorForFormSubmit() ? new IndicatingAjaxButton(id, labelModel){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                onClick.accept((Object)this, (Object)target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                if (isPreventDoubleClickForFormSubmit) {
                    PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{this.getForm()});
            }
        } : new AjaxButton(id, labelModel){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                onClick.accept((Object)this, (Object)target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                if (isPreventDoubleClickForFormSubmit) {
                    PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{this.getForm()});
            }
        };
    }

    public static AjaxButton buttonAdd(MarkupContainer markupContainer, String id, IModel<String> labelModel, SerializableBiConsumer<AjaxButton, AjaxRequestTarget> onClick) {
        return Wkt.add(markupContainer, Wkt.button(id, labelModel, onClick));
    }

    public static AjaxButton buttonAddOk(MarkupContainer markupContainer, String id, IModel<String> labelModel, IsisConfiguration.Viewer.Wicket settings, SerializableBiConsumer<AjaxButton, AjaxRequestTarget> onClick) {
        return Wkt.add(markupContainer, Wkt.buttonOk(id, labelModel, settings, onClick));
    }

    public static CheckBoxX checkboxX(String id, IModel<Boolean> checkedModel, boolean required, CheckBoxXConfig.Sizes size) {
        final CheckBoxXConfig config = new CheckBoxXConfig(){
            private static final long serialVersionUID = 1L;
            {
                this.put((IKey)new Key("tabindex"), "0");
            }
        }.withSize(size).withEnclosedLabel(false).withIconChecked(fragment_prompt_checkboxYes).withIconNull(fragment_prompt_checkboxIntermediate).withIconUnchecked(fragment_prompt_checkboxNo).withThreeState(!required);
        CheckBoxX checkBox = new CheckBoxX(id, checkedModel){
            private static final long serialVersionUID = 1L;

            public CheckBoxXConfig getConfig() {
                return config;
            }

            public void renderHead(IHeaderResponse response) {
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(CheckBoxX.class, "css/checkbox-x.css")));
                response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JQueryPluginResourceReference(CheckBoxX.class, "js/checkbox-x.js")));
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.$((Component)this).chain((CharSequence)"checkboxX", (Config)this.getConfig(), new Config[0]).get()));
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("type", (CharSequence)"xx");
            }
        };
        return Wkt.ajaxEnable(checkBox);
    }

    public static AjaxCheckBox checkbox(String id, IModel<Boolean> checkedModel, final SerializableConsumer<AjaxRequestTarget> onUpdate) {
        return new AjaxCheckBox(id, checkedModel){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                onUpdate.accept((Object)target);
            }

            public void onEvent(IEvent<?> event) {
                _Casts.castTo(IsisEnvelopeEvent.class, (Object)event.getPayload()).ifPresent(envelopeEvent -> {
                    if (envelopeEvent.getLetter() instanceof IsisActionCompletedEvent && Boolean.TRUE.equals(this.getModelObject())) {
                        this.setModelObject(false);
                        envelopeEvent.getTarget().add(new Component[]{this});
                    }
                });
                super.onEvent(event);
            }
        };
    }

    public static AjaxCheckBox checkboxAdd(MarkupContainer container, String id, IModel<Boolean> checkedModel, SerializableConsumer<AjaxRequestTarget> onUpdate) {
        return Wkt.add(container, Wkt.checkbox(id, checkedModel, onUpdate));
    }

    public static WebMarkupContainer container(String id) {
        WebMarkupContainer component = new WebMarkupContainer(id);
        component.setOutputMarkupId(true);
        return component;
    }

    public static WebMarkupContainer containerWithVisibility(String id, final SerializableBooleanSupplier isVisible) {
        WebMarkupContainer component = new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return isVisible.getAsBoolean();
            }
        };
        component.setOutputMarkupId(true);
        return component;
    }

    public static WebMarkupContainer containerAdd(MarkupContainer container, String id) {
        return Wkt.add(container, Wkt.container(id));
    }

    public static ComponentTag cssAppend(ComponentTag tag, @Nullable String cssClass) {
        if (_Strings.isNotEmpty((CharSequence)cssClass)) {
            tag.append("class", (CharSequence)cssClass, " ");
        }
        return tag;
    }

    public static <T extends Component> T cssAppend(T component, @Nullable String cssClass) {
        if (_Strings.isNotEmpty((CharSequence)cssClass)) {
            component.add(new Behavior[]{new CssClassNameAppender(new String[]{cssClass})});
        }
        return component;
    }

    public static <T extends Component> T cssAppend(T component, @Nullable IModel<String> cssClassModel) {
        if (cssClassModel != null) {
            component.add(new Behavior[]{new CssClassNameAppender(cssClassModel)});
        }
        return component;
    }

    public static <T extends Component> T cssAppend(T component, Identifier identifier) {
        return Wkt.cssAppend(component, Wkt.cssNormalize(identifier));
    }

    public static <T extends Component> T cssReplace(T component, @Nullable String cssClass) {
        component.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)_Strings.nullToEmpty((String)cssClass)))});
        return component;
    }

    public static String cssNormalize(Identifier identifier) {
        StringBuilder sb = new StringBuilder();
        sb.append("isis-");
        sb.append(identifier.getLogicalType().getLogicalTypeName());
        if (_Strings.isNullOrEmpty((CharSequence)identifier.getMemberLogicalName())) {
            sb.append("-");
            sb.append(identifier.getMemberLogicalName());
        }
        return Wkt.cssNormalize(sb.toString());
    }

    public static String cssNormalize(String cssClass) {
        String trimmed = _Strings.blankToNullOrTrim((String)cssClass);
        return _Strings.isNullOrEmpty((CharSequence)trimmed) ? null : cssClass.replaceAll("\\.", "-").replaceAll("[^A-Za-z0-9- ]", "").replaceAll("\\s+", "-");
    }

    public static ResourceLinkVolatile downloadLinkNoCache(String id, IResource resourceModel) {
        return new ResourceLinkVolatile(id, resourceModel);
    }

    public static FileUploadField fileUploadField(String id, String initialCaption, IModel<List<FileUpload>> model) {
        BootstrapFileInputField fileUploadField = new BootstrapFileInputField(id, model){
            private static final long serialVersionUID = 1L;

            public boolean isRequired() {
                return false;
            }
        };
        fileUploadField.getConfig().maxFileCount(1).mainClass("input-group-sm").initialCaption(initialCaption).captionClass("form-control-sm").showUpload(false);
        return fileUploadField;
    }

    public static String faIcon(String faClasses) {
        return String.format("<i class=\"%s\"></i>", faClasses);
    }

    public static Fragment fragment(String id, String fragmentId, MarkupContainer markupProvider) {
        return new Fragment(id, fragmentId, markupProvider);
    }

    public static Fragment fragmentDebug(String id, String fragmentId, MarkupContainer markupProvider) {
        return new Fragment(id, fragmentId, markupProvider){
            private static final long serialVersionUID = 1L;

            public MarkupContainer add(Component ... children) {
                for (Component child : children) {
                    System.err.printf("add %s -> %s %n", this.getId(), child.getId());
                }
                return super.add(children);
            }

            public MarkupContainer addOrReplace(Component ... children) {
                for (Component child : children) {
                    System.err.printf("addOrReplace %s -> %s %n", this.getId(), child.getId());
                }
                return super.addOrReplace(children);
            }
        };
    }

    public static Fragment fragmentNoTab(String id, String fragmentId, MarkupContainer markupProvider) {
        return new Fragment(id, fragmentId, markupProvider){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("tabindex", (CharSequence)"-1");
            }
        };
    }

    public static Fragment fragmentAdd(MarkupContainer container, String id, String fragmentId, MarkupContainer markupProvider) {
        return Wkt.add(container, Wkt.fragment(id, fragmentId, markupProvider));
    }

    public static Fragment fragmentAddNoTab(MarkupContainer container, String id, String fragmentId, MarkupContainer markupProvider) {
        return Wkt.add(container, Wkt.fragmentNoTab(id, fragmentId, markupProvider));
    }

    public static Form<Object> form(String id) {
        return new Form(id);
    }

    public static Form<Object> formAdd(MarkupContainer container, String id) {
        return Wkt.add(container, Wkt.form(id));
    }

    public static Image imageCachable(String id, ResourceReference imageResource) {
        return new Image(id, imageResource, new ResourceReference[0]){
            private static final long serialVersionUID = 1L;

            protected boolean shouldAddAntiCacheParameter() {
                return false;
            }
        };
    }

    public static Image imageAddCachable(MarkupContainer container, String id, ResourceReference imageResource) {
        return Wkt.add(container, Wkt.imageCachable(id, imageResource));
    }

    public static Label label(String id, String label) {
        return new Label(id, (Serializable)((Object)label));
    }

    public static Label label(String id, IModel<String> labelModel) {
        return new Label(id, labelModel);
    }

    public static Label labelWithDynamicEscaping(String id, final _Functions.SerializableSupplier<UiString> labelModel) {
        Label label = new Label(id, (IModel & Serializable)() -> ((UiString)labelModel.get()).getString()){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> type) {
                this.setEscapeModelStrings(!((UiString)labelModel.get()).isMarkup());
                return super.getConverter(type);
            }
        };
        return label;
    }

    public static Label labelNoTab(String id, IModel<String> labelModel) {
        return new Label(id, labelModel){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("tabindex", (CharSequence)"-1");
            }
        };
    }

    public static <T> Label labelWithConverter(String id, IModel<T> model, final Class<T> type, final IConverter<T> converter) {
        return new Label(id, model){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> cType) {
                return cType == type ? converter : super.getConverter(cType);
            }
        };
    }

    public static Label labelAdd(MarkupContainer container, String id, String label) {
        return Wkt.add(container, Wkt.label(id, label));
    }

    public static Label labelAdd(MarkupContainer container, String id, IModel<String> labelModel) {
        return Wkt.add(container, new Label(id, labelModel));
    }

    public static Label labelAddNoTab(MarkupContainer container, String id, IModel<String> labelModel) {
        return Wkt.add(container, Wkt.labelNoTab(id, labelModel));
    }

    public static <T> Label labelAddWithConverter(MarkupContainer container, String id, IModel<T> model, Class<T> type, IConverter<T> converter) {
        return Wkt.add(container, Wkt.labelWithConverter(id, model, type, converter));
    }

    public static AjaxLinkNoPropagate link(String id, SerializableConsumer<AjaxRequestTarget> onClick) {
        return new AjaxLinkNoPropagate(id, onClick);
    }

    public static AjaxLinkNoPropagate linkAdd(MarkupContainer container, String id, SerializableConsumer<AjaxRequestTarget> onClick) {
        return Wkt.add(container, Wkt.link(id, onClick));
    }

    public static AjaxLinkNoPropagate linkWithBody(String id, final String bodyHtml, SerializableConsumer<AjaxRequestTarget> onClick) {
        return new AjaxLinkNoPropagate(id, onClick){
            private static final long serialVersionUID = 1L;

            public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                this.replaceComponentTagBody(markupStream, openTag, bodyHtml);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.setType(XmlTag.TagType.OPEN);
            }
        };
    }

    public static AjaxLinkNoPropagate linkAddWithBody(MarkupContainer container, String id, String bodyHtml, SerializableConsumer<AjaxRequestTarget> onClick) {
        return Wkt.add(container, Wkt.linkWithBody(id, bodyHtml, onClick));
    }

    public static AjaxLinkNoPropagate linkAddWithBody(RepeatingView rv, String bodyHtml, SerializableConsumer<AjaxRequestTarget> onClick) {
        return Wkt.linkAddWithBody((MarkupContainer)rv, rv.newChildId(), bodyHtml, onClick);
    }

    public static <T> ListView<T> listView(String id, List<T> list, final SerializableConsumer<ListItem<T>> itemPopulator) {
        return new ListView<T>(id, list){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                itemPopulator.accept(item);
            }
        };
    }

    public static <T> ListView<T> listView(String id, IModel<? extends List<T>> listModel, final SerializableConsumer<ListItem<T>> itemPopulator) {
        return new ListView<T>(id, listModel){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                itemPopulator.accept(item);
            }
        };
    }

    public static <T> ListView<T> listViewAdd(MarkupContainer container, String id, List<T> list, SerializableConsumer<ListItem<T>> itemPopulator) {
        return Wkt.add(container, Wkt.listView(id, list, itemPopulator));
    }

    public static <T> ListView<T> listViewAdd(MarkupContainer container, String id, IModel<? extends List<T>> listModel, SerializableConsumer<ListItem<T>> itemPopulator) {
        return Wkt.add(container, Wkt.listView(id, listModel, itemPopulator));
    }

    public static MarkupComponent markup(String id, IModel<String> htmlModel) {
        return new MarkupComponent(id, htmlModel);
    }

    public static MarkupComponent markup(String id, String html) {
        return Wkt.markup(id, (IModel<String>)Model.of((Serializable)((Object)html)));
    }

    public static MarkupComponent markupAdd(MarkupContainer container, String id, IModel<String> htmlModel) {
        return Wkt.add(container, Wkt.markup(id, htmlModel));
    }

    public static MarkupComponent markupAdd(MarkupContainer container, String id, String html) {
        return Wkt.add(container, Wkt.markup(id, html));
    }

    public static RepeatingView repeatingView(String id) {
        return new RepeatingView(id);
    }

    public static RepeatingView repeatingViewAdd(MarkupContainer container, String id) {
        return Wkt.add(container, Wkt.repeatingView(id));
    }

    public static <T> Item<T> oddEvenItem(String id, int index, final IModel<T> model, final _Functions.SerializableFunction<T, String> cssClassProvider) {
        return new OddEvenItem<T>(id, index, model){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Wkt.cssAppend(tag, (String)cssClassProvider.apply(model.getObject()));
            }
        };
    }

    public static TextArea<String> textArea(String id, IModel<String> textModel) {
        return new TextArea(id, textModel);
    }

    public static TextArea<String> textAreaNoTab(String id, IModel<String> textModel) {
        return new TextArea<String>(id, textModel){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("tabindex", (CharSequence)"-1");
            }
        };
    }

    public static <T> TextArea<T> textAreaWithConverter(String id, IModel<T> model, final Class<T> type, final @Nullable IConverter<T> converter) {
        return converter != null ? new TextArea<T>(id, model){
            private static final long serialVersionUID = 1L;
            {
                super(id, model);
                this.setType(type);
            }

            public <C> IConverter<C> getConverter(Class<C> cType) {
                return cType == type ? converter : super.getConverter(cType);
            }

            public void error(IValidationError error) {
                Wkt.errorMessageIgnoringResourceBundles(this, error);
            }
        } : new TextArea(id, model);
    }

    public static <T> TextField<T> textFieldWithConverter(String id, IModel<T> model, final Class<T> type, final @Nullable IConverter<T> converter) {
        return converter != null ? new TextField<T>(id, model, type){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> cType) {
                return cType == type ? converter : super.getConverter(cType);
            }

            public void error(IValidationError error) {
                Wkt.errorMessageIgnoringResourceBundles(this, error);
            }
        } : new TextField(id, model, type);
    }

    public static <T> TextField<T> passwordFieldWithConverter(String id, IModel<T> model, final Class<T> type, final @NonNull IConverter<T> converter) {
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        return new TextField<T>(id, model, type){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> cType) {
                return cType == type ? converter : super.getConverter(cType);
            }

            public void error(IValidationError error) {
                Wkt.errorMessageIgnoringResourceBundles(this, error);
            }

            protected void onComponentTag(ComponentTag tag) {
                Attributes.set((ComponentTag)tag, (String)"type", (String)"password");
                super.onComponentTag(tag);
            }

            protected String[] getInputTypes() {
                return new String[]{"password"};
            }
        };
    }

    public static void focusOnMarkerAttribute(MarkupContainer container, AjaxRequestTarget target) {
        container.streamChildren().filter(child -> child.getMarkupAttributes().containsKey((Object)"data-isis-focus")).findFirst().ifPresent(child -> target.focusComponent(child));
    }

    public static void javaScriptAdd(AjaxRequestTarget target, EventTopic topic, String containerId) {
        target.appendJavaScript((CharSequence)Wkt.javaScriptFor(topic, containerId));
    }

    public static void javaScriptAdd(IHeaderResponse response, EventTopic topic, String containerId) {
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)Wkt.javaScriptFor(topic, containerId)));
    }

    private static String javaScriptFor(EventTopic topic, String containerId) {
        return _Strings.isNotEmpty((CharSequence)containerId) ? String.format("Wicket.Event.publish(Isis.Topic.%s, '%s')", topic.name(), containerId) : String.format("Wicket.Event.publish(Isis.Topic.%s)", topic.name());
    }

    public static Component noTabbing(@Nullable Component component) {
        if (component != null) {
            component.add(new Behavior[]{new AttributeAppender("tabindex", (Serializable)((Object)"-1"))});
        }
        return component;
    }

    private static void errorMessageIgnoringResourceBundles(@Nullable FormComponent<?> formComponent, @Nullable IValidationError error) {
        if (formComponent == null || error == null) {
            return;
        }
        if (error instanceof ValidationError) {
            String message = ((ValidationError)error).getMessage();
            if (_Strings.isNotEmpty((CharSequence)message)) {
                formComponent.error((Serializable)((Object)message));
            } else {
                formComponent.error((Serializable)((Object)"Unspecified error (no message associated)."));
            }
        } else {
            formComponent.error(error);
        }
    }

    public static void setFormComponentAttributes(FormComponent<?> formComponent, Supplier<OptionalInt> multilineNumberOfLines, Supplier<OptionalInt> maxLength, Supplier<OptionalInt> typicalLength) {
        if (formComponent instanceof TextArea) {
            multilineNumberOfLines.get().ifPresent(numberOfLines -> Wkt.attributeReplace(formComponent, "rows", numberOfLines));
        }
        maxLength.get().ifPresent(maxLen -> {
            Wkt.attributeReplace(formComponent, "maxlength", maxLen);
            if (formComponent.getType().equals(String.class)) {
                formComponent.add(new Behavior[]{StringValidator.maximumLength((int)maxLen)});
            }
        });
        typicalLength.get().ifPresent(typicalLen -> Wkt.attributeReplace(formComponent, "size", typicalLen));
    }

    @Deprecated
    public static void fixDisabledState(Component component, ComponentTag tag) {
        if (!component.isEnabledInHierarchy()) {
            if (component instanceof AbstractLink) {
                tag.setName("a");
            } else if (component instanceof Button) {
                tag.setName("button");
            } else if (tag.getAttribute("value") != null) {
                tag.setName("input");
            } else {
                tag.setName("button");
            }
            tag.put("disabled", (CharSequence)"disabled");
        }
    }

    private Wkt() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum EventTopic {
        FOCUS_FIRST_PROPERTY,
        FOCUS_FIRST_PARAMETER,
        OPEN_SELECT2;

    }

    private static class ReplaceDisabledTagWithReadonlyTagBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        private ReplaceDisabledTagWithReadonlyTagBehavior() {
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            super.onComponentTag(component, tag);
            if (component.isEnabled()) {
                return;
            }
            tag.remove("disabled");
            tag.put("readonly", (CharSequence)"readonly");
        }
    }
}

