/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameRemover;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationConfig;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.commons.model.action.decorator.UiActionDecorator;
import org.apache.isis.viewer.commons.model.decorators.ConfirmDecorator;
import org.apache.isis.viewer.commons.model.decorators.DangerDecorator;
import org.apache.isis.viewer.commons.model.decorators.DisablingDecorator;
import org.apache.isis.viewer.commons.model.decorators.FormLabelDecorator;
import org.apache.isis.viewer.commons.model.decorators.IconDecorator;
import org.apache.isis.viewer.commons.model.decorators.PrototypingDecorator;
import org.apache.isis.viewer.commons.model.decorators.TooltipDecorator;
import org.apache.isis.viewer.commons.model.layout.UiPlacementDirection;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.CssClassFaBehavior;
import org.apache.isis.viewer.wicket.ui.util.BootstrapConstants;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public final class WktDecorators {
    private static final AtomicReference<Object> formLabel = new AtomicReference();
    private static final AtomicReference<Object> tooltip = new AtomicReference();
    private static final AtomicReference<Object> disable = new AtomicReference();
    private static final AtomicReference<Object> prototyping = new AtomicReference();
    private static final AtomicReference<Object> confirm = new AtomicReference();
    private static final AtomicReference<Object> danger = new AtomicReference();
    private static final AtomicReference<Object> icon = new AtomicReference();
    private static final AtomicReference<Object> missingIcon = new AtomicReference();
    private static final AtomicReference<Object> actionLink = new AtomicReference();

    private WktDecorators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormLabel getFormLabel() {
        Object value = formLabel.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = formLabel;
            synchronized (atomicReference) {
                value = formLabel.get();
                if (value == null) {
                    FormLabel actualValue = new FormLabel();
                    value = actualValue == null ? formLabel : actualValue;
                    formLabel.set(value);
                }
            }
        }
        return (FormLabel)(value == formLabel ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tooltip getTooltip() {
        Object value = tooltip.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = tooltip;
            synchronized (atomicReference) {
                value = tooltip.get();
                if (value == null) {
                    Tooltip actualValue = new Tooltip();
                    value = actualValue == null ? tooltip : actualValue;
                    tooltip.set(value);
                }
            }
        }
        return (Tooltip)(value == tooltip ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Disable getDisable() {
        Object value = disable.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = disable;
            synchronized (atomicReference) {
                value = disable.get();
                if (value == null) {
                    Disable actualValue = new Disable();
                    value = actualValue == null ? disable : actualValue;
                    disable.set(value);
                }
            }
        }
        return (Disable)(value == disable ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prototyping getPrototyping() {
        Object value = prototyping.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = prototyping;
            synchronized (atomicReference) {
                value = prototyping.get();
                if (value == null) {
                    Prototyping actualValue = new Prototyping();
                    value = actualValue == null ? prototyping : actualValue;
                    prototyping.set(value);
                }
            }
        }
        return (Prototyping)(value == prototyping ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Confirm getConfirm() {
        Object value = confirm.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = confirm;
            synchronized (atomicReference) {
                value = confirm.get();
                if (value == null) {
                    Confirm actualValue = new Confirm();
                    value = actualValue == null ? confirm : actualValue;
                    confirm.set(value);
                }
            }
        }
        return (Confirm)(value == confirm ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Danger getDanger() {
        Object value = danger.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = danger;
            synchronized (atomicReference) {
                value = danger.get();
                if (value == null) {
                    Danger actualValue = new Danger();
                    value = actualValue == null ? danger : actualValue;
                    danger.set(value);
                }
            }
        }
        return (Danger)(value == danger ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IconDecoratorWkt getIcon() {
        Object value = icon.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = icon;
            synchronized (atomicReference) {
                value = icon.get();
                if (value == null) {
                    IconDecoratorWkt actualValue = new IconDecoratorWkt();
                    value = actualValue == null ? icon : actualValue;
                    icon.set(value);
                }
            }
        }
        return (IconDecoratorWkt)(value == icon ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MissingIconDecorator getMissingIcon() {
        Object value = missingIcon.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = missingIcon;
            synchronized (atomicReference) {
                value = missingIcon.get();
                if (value == null) {
                    MissingIconDecorator actualValue = new MissingIconDecorator();
                    value = actualValue == null ? missingIcon : actualValue;
                    missingIcon.set(value);
                }
            }
        }
        return (MissingIconDecorator)(value == missingIcon ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionLink getActionLink() {
        Object value = actionLink.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = actionLink;
            synchronized (atomicReference) {
                value = actionLink.get();
                if (value == null) {
                    ActionLink actualValue = new ActionLink();
                    value = actualValue == null ? actionLink : actualValue;
                    actionLink.set(value);
                }
            }
        }
        return (ActionLink)((Object)(value == actionLink ? null : value));
    }

    public static final class ActionLink
    extends UiActionDecorator<Component> {
        public ActionLink() {
            super((TooltipDecorator)WktDecorators.getTooltip(), (DisablingDecorator)WktDecorators.getDisable(), (ConfirmDecorator)WktDecorators.getConfirm(), (PrototypingDecorator)WktDecorators.getPrototyping(), (IconDecorator)WktDecorators.getIcon());
        }

        private <T extends Component> void commonDecorateMenuItem(T uiComponent, LinkAndLabel linkAndLabel, TranslationService translationService) {
            AjaxLink actionLinkUiComponent = linkAndLabel.getUiComponent();
            ObjectAction actionMeta = linkAndLabel.getManagedAction().getAction();
            linkAndLabel.getDisableUiModel().ifPresent(disableUiModel -> {
                this.getDisableDecorator().decorate((Object)uiComponent, disableUiModel);
                this.getTooltipDecorator().decorate((Object)uiComponent, TooltipDecorator.TooltipDecorationModel.ofBody((UiPlacementDirection)UiPlacementDirection.BOTTOM, (String)disableUiModel.getReason()));
            });
            if (!linkAndLabel.getDisableUiModel().isPresent()) {
                linkAndLabel.getDescription().ifPresent(describedAs -> this.getTooltipDecorator().decorate((Object)uiComponent, TooltipDecorator.TooltipDecorationModel.ofBody((UiPlacementDirection)UiPlacementDirection.BOTTOM, (String)describedAs)));
                if (actionMeta.isImmediateConfirmationRequired()) {
                    ConfirmDecorator.ConfirmDecorationModel confirmUiModel = ConfirmDecorator.ConfirmDecorationModel.areYouSure((TranslationService)translationService, (UiPlacementDirection)UiPlacementDirection.BOTTOM);
                    this.getConfirmDecorator().decorate((Object)actionLinkUiComponent, confirmUiModel);
                }
            }
            if (actionMeta.isPrototype()) {
                this.getPrototypingDecorator().decorate((Object)actionLinkUiComponent, PrototypingDecorator.PrototypingDecorationModel.of((ManagedAction)linkAndLabel.getManagedAction()));
            }
        }

        public void decorateMenuItem(Component uiComponent, LinkAndLabel linkAndLabel, TranslationService translationService) {
            Wkt.cssAppend(uiComponent, linkAndLabel.getFeatureIdentifier());
            this.commonDecorateMenuItem(uiComponent, linkAndLabel, translationService);
            linkAndLabel.getAdditionalCssClass().ifPresent(cssClass -> Wkt.cssAppend(linkAndLabel.getUiComponent(), cssClass));
        }
    }

    public static final class MissingIconDecorator
    implements IconDecorator<Component, Component> {
        public Component decorate(Component uiComponent, Optional<IconDecorator.FontAwesomeDecorationModel> fontAwesome) {
            if (!fontAwesome.isPresent()) {
                Wkt.cssAppend(uiComponent, "menuLinkSpacer");
            }
            return uiComponent;
        }
    }

    public static final class IconDecoratorWkt
    implements IconDecorator<Component, Component> {
        public Component decorate(Component uiComponent, Optional<IconDecorator.FontAwesomeDecorationModel> fontAwesome) {
            if (fontAwesome.isPresent()) {
                uiComponent.add(new Behavior[]{new CssClassFaBehavior(fontAwesome.get())});
            }
            return uiComponent;
        }
    }

    public static final class Danger
    implements DangerDecorator<Component> {
        private final CssClassNameRemover cssButtonSemanticsRemover = BootstrapConstants.ButtonSemantics.createButtonSemanticsRemover();

        public void decorate(Component uiComponent) {
            uiComponent.add(new Behavior[]{this.cssButtonSemanticsRemover});
            Wkt.cssAppend(uiComponent, BootstrapConstants.ButtonSemantics.DANGER.buttonDefaultCss());
        }
    }

    public static final class Confirm
    implements ConfirmDecorator<Component> {
        public void decorate(Component uiComponent, ConfirmDecorator.ConfirmDecorationModel decorationModel) {
            ConfirmationConfig confirmationConfig = new ConfirmationConfig().withTitle(decorationModel.getTitle()).withBtnOkLabel(decorationModel.getOkLabel()).withBtnCancelLabel(decorationModel.getCancelLabel()).withBtnOkClass(BootstrapConstants.ButtonSemantics.DANGER.fullButtonCss()).withBtnCancelClass(BootstrapConstants.ButtonSemantics.SECONDARY.fullButtonCss()).withPlacement(TooltipConfig.Placement.valueOf((String)decorationModel.getPlacement().name().toLowerCase()));
            Wkt.behaviorAddConfirm(uiComponent, confirmationConfig);
            if (uiComponent instanceof Button) {
                WktDecorators.getDanger().decorate(uiComponent);
            }
        }
    }

    public static final class Prototyping
    implements PrototypingDecorator<Component, Component> {
        public Component decorate(Component uiComponent, PrototypingDecorator.PrototypingDecorationModel decorationModel) {
            Wkt.cssAppend(uiComponent, "prototype");
            return uiComponent;
        }
    }

    public static final class Disable
    implements DisablingDecorator<Component> {
        public void decorate(Component uiComponent, DisablingDecorator.DisablingDecorationModel decorationModel) {
            TooltipDecorator.TooltipDecorationModel tooltipDecorationModel = TooltipDecorator.TooltipDecorationModel.ofBody((UiPlacementDirection)UiPlacementDirection.BOTTOM, (String)decorationModel.getReason());
            WktDecorators.getTooltip().decorate(uiComponent, tooltipDecorationModel);
            Wkt.cssAppend(uiComponent, "disabled");
            uiComponent.setEnabled(false);
        }
    }

    public static final class Tooltip
    implements TooltipDecorator<Component> {
        public void decorate(Component uiComponent, TooltipDecorator.TooltipDecorationModel decorationModel) {
            WktTooltips.addTooltip(uiComponent, decorationModel);
        }
    }

    public static final class FormLabel
    implements FormLabelDecorator<Component> {
        public void decorate(Component uiComponent, FormLabelDecorator.FormLabelDecorationModel decorationModel) {
            if (decorationModel.isMandatoryMarker()) {
                Wkt.cssAppend(uiComponent, "mandatory");
            }
            if (_Strings.isNotEmpty((CharSequence)decorationModel.getSuffix())) {
                IModel labelModel = (IModel)_Casts.uncheckedCast((Object)uiComponent.getDefaultModel());
                uiComponent.setDefaultModel((IModel)Model.of((Serializable)((Object)((String)labelModel.getObject() + decorationModel.getSuffix()))));
            }
            uiComponent.setEscapeModelStrings(true);
        }
    }
}

