/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.io.Serializable;
import java.util.List;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.UpdatedFlags;

public interface MailboxListener {
    public void event(Event var1);

    public static abstract class Added
    extends MessageEvent {
        private static final long serialVersionUID = 1L;

        public Added(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract MessageMetaData getMetaData(long var1);
    }

    public static abstract class FlagsUpdated
    extends MessageEvent {
        private static final long serialVersionUID = 1L;

        public FlagsUpdated(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract List<UpdatedFlags> getUpdatedFlags();
    }

    public static abstract class Expunged
    extends MessageEvent {
        private static final long serialVersionUID = 1L;

        public Expunged(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract MessageMetaData getMetaData(long var1);
    }

    public static abstract class MessageEvent
    extends Event {
        private static final long serialVersionUID = 1L;

        public MessageEvent(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract List<Long> getUids();
    }

    public static abstract class MailboxACLUpdated
    extends MessageEvent {
        private static final long serialVersionUID = 1L;

        public MailboxACLUpdated(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract MailboxACL getUpdatedACL();
    }

    public static abstract class MailboxRenamed
    extends Event {
        private static final long serialVersionUID = 1L;

        public MailboxRenamed(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract MailboxPath getNewPath();
    }

    public static class MailboxAdded
    extends Event {
        private static final long serialVersionUID = 1L;

        public MailboxAdded(MailboxSession session, MailboxPath path) {
            super(session, path);
        }
    }

    public static class MailboxDeletion
    extends Event {
        private static final long serialVersionUID = 1L;

        public MailboxDeletion(MailboxSession session, MailboxPath path) {
            super(session, path);
        }
    }

    public static abstract class Event
    implements Serializable {
        private final MailboxSession session;
        private final MailboxPath path;

        public Event(MailboxSession session, MailboxPath path) {
            this.session = session;
            this.path = path;
        }

        public MailboxSession getSession() {
            return this.session;
        }

        public MailboxPath getMailboxPath() {
            return this.path;
        }
    }
}

