/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import java.util.HashSet;
import java.util.Set;
import org.apache.james.mailbox.acl.GroupMembershipResolver;

public class SimpleGroupMembershipResolver
implements GroupMembershipResolver {
    private Set<Membership> memberships = new HashSet<Membership>(32);

    public void addMembership(String group, String user) {
        this.memberships.add(new Membership(user, group));
    }

    @Override
    public boolean isMember(String user, String group) {
        return this.memberships.contains(new Membership(user, group));
    }

    private static class Membership {
        private final String group;
        private final int hash;
        private final String user;

        public Membership(String user, String group) {
            this.group = group;
            this.user = user;
            int PRIME = 31;
            this.hash = 31 * this.group.hashCode() + this.user.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Membership) {
                Membership other = (Membership)o;
                return this.group == other.group || this.group != null && this.group.equals(other.group) && this.user == other.user || this.user != null && this.user.equals(other.user);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.group + ": " + this.user;
        }
    }
}

