/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import java.util.ArrayList;
import java.util.Map;
import javax.mail.Flags;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.SimpleMailboxACL;

public class UnionMailboxACLResolver
implements MailboxACLResolver {
    public static final MailboxACL DEFAULT_GLOBAL_GROUP_ACL = SimpleMailboxACL.OWNER_FULL_EXCEPT_ADMINISTRATION_ACL;
    public static final MailboxACL DEFAULT_GLOBAL_USER_ACL = SimpleMailboxACL.OWNER_FULL_ACL;
    private static final int POSITIVE_INDEX = 0;
    private static final int NEGATIVE_INDEX = 1;
    private final MailboxACL groupGlobalACL;
    private final MailboxACL userGlobalACL;

    public UnionMailboxACLResolver() {
        this.userGlobalACL = DEFAULT_GLOBAL_USER_ACL;
        this.groupGlobalACL = DEFAULT_GLOBAL_GROUP_ACL;
    }

    public UnionMailboxACLResolver(MailboxACL userGlobalACL, MailboxACL groupGlobalACL) {
        if (userGlobalACL == null) {
            throw new NullPointerException("Missing userGlobalACL.");
        }
        if (groupGlobalACL == null) {
            throw new NullPointerException("Missing groupGlobalACL.");
        }
        this.userGlobalACL = userGlobalACL;
        this.groupGlobalACL = groupGlobalACL;
    }

    protected static boolean applies(MailboxACL.MailboxACLEntryKey aclKey, MailboxACL.MailboxACLEntryKey queryKey, GroupMembershipResolver groupMembershipResolver, String resourceOwner, boolean resourceOwnerIsGroup) {
        String aclKeyName = aclKey.getName();
        MailboxACL.NameType aclKeyNameType = aclKey.getNameType();
        if (MailboxACL.SpecialName.anybody.name().equals(aclKeyName)) {
            return true;
        }
        if (queryKey != null) {
            String queryUserOrGroupName = queryKey.getName();
            switch (queryKey.getNameType()) {
                case user: {
                    switch (aclKeyNameType) {
                        case special: {
                            if (MailboxACL.SpecialName.authenticated.name().equals(aclKeyName)) {
                                return true;
                            }
                            if (MailboxACL.SpecialName.owner.name().equals(aclKeyName)) {
                                return !resourceOwnerIsGroup && queryUserOrGroupName.equals(resourceOwner) || resourceOwnerIsGroup && groupMembershipResolver.isMember(queryUserOrGroupName, resourceOwner);
                            }
                            throw new IllegalStateException("Unexpected " + MailboxACL.SpecialName.class.getName() + "." + aclKeyName);
                        }
                        case user: {
                            return aclKeyName.equals(queryUserOrGroupName);
                        }
                        case group: {
                            return groupMembershipResolver.isMember(queryUserOrGroupName, aclKeyName);
                        }
                    }
                    throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + (Object)((Object)aclKeyNameType));
                }
                case group: {
                    switch (aclKeyNameType) {
                        case special: {
                            if (MailboxACL.SpecialName.authenticated.name().equals(aclKeyName)) {
                                return true;
                            }
                            if (MailboxACL.SpecialName.owner.name().equals(aclKeyName)) {
                                return resourceOwnerIsGroup && queryUserOrGroupName.equals(resourceOwner);
                            }
                            throw new IllegalStateException("Unexpected " + MailboxACL.SpecialName.class.getName() + "." + aclKeyName);
                        }
                        case user: {
                            return false;
                        }
                        case group: {
                            return aclKeyName.equals(queryUserOrGroupName);
                        }
                    }
                    throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + (Object)((Object)aclKeyNameType));
                }
                case special: {
                    switch (aclKeyNameType) {
                        case special: {
                            if (aclKeyName.equals(queryUserOrGroupName)) {
                                return true;
                            }
                            return MailboxACL.SpecialName.owner.name().equals(queryUserOrGroupName) && MailboxACL.SpecialName.authenticated.name().equals(aclKeyName);
                        }
                        case user: 
                        case group: {
                            return false;
                        }
                    }
                    throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + (Object)((Object)aclKeyNameType));
                }
            }
            throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + (Object)((Object)queryKey.getNameType()));
        }
        return false;
    }

    @Override
    public MailboxACL applyGlobalACL(MailboxACL resourceACL, boolean resourceOwnerIsGroup) throws UnsupportedRightException {
        return resourceOwnerIsGroup ? resourceACL.union(this.groupGlobalACL) : resourceACL.union(this.userGlobalACL);
    }

    @Override
    public boolean hasRight(String requestUser, GroupMembershipResolver groupMembershipResolver, MailboxACL.MailboxACLRight right, MailboxACL resourceACL, String resourceOwner, boolean resourceOwnerIsGroup) throws UnsupportedRightException {
        MailboxACL.MailboxACLEntryKey key;
        Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> entries;
        SimpleMailboxACL.SimpleMailboxACLEntryKey queryKey = requestUser == null ? null : new SimpleMailboxACL.SimpleMailboxACLEntryKey(requestUser, MailboxACL.NameType.user, false);
        boolean result = false;
        Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> map = entries = resourceOwnerIsGroup ? this.groupGlobalACL.getEntries() : this.userGlobalACL.getEntries();
        if (entries != null) {
            for (Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> entry : entries.entrySet()) {
                key = entry.getKey();
                if (!UnionMailboxACLResolver.applies(key, queryKey, groupMembershipResolver, resourceOwner, resourceOwnerIsGroup) || !entry.getValue().contains(right)) continue;
                if (key.isNegative()) {
                    return false;
                }
                result = true;
            }
        }
        if (resourceACL != null && (entries = resourceACL.getEntries()) != null) {
            for (Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> entry : entries.entrySet()) {
                key = entry.getKey();
                if (!UnionMailboxACLResolver.applies(key, queryKey, groupMembershipResolver, resourceOwner, resourceOwnerIsGroup) || !entry.getValue().contains(right)) continue;
                if (key.isNegative()) {
                    return false;
                }
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean isReadWrite(MailboxACL.MailboxACLRights mailboxACLRights, Flags sharedFlags) throws UnsupportedRightException {
        if (mailboxACLRights.contains(SimpleMailboxACL.Rfc4314Rights.i_Insert_RIGHT) || mailboxACLRights.contains(SimpleMailboxACL.Rfc4314Rights.e_PerformExpunge_RIGHT)) {
            return true;
        }
        if (sharedFlags != null) {
            if (sharedFlags.contains(Flags.Flag.DELETED) && mailboxACLRights.contains(SimpleMailboxACL.Rfc4314Rights.t_DeleteMessages_RIGHT)) {
                return true;
            }
            if (sharedFlags.contains(Flags.Flag.SEEN) && mailboxACLRights.contains(SimpleMailboxACL.Rfc4314Rights.s_WriteSeenFlag_RIGHT)) {
                return true;
            }
            boolean hasWriteRight = mailboxACLRights.contains(SimpleMailboxACL.Rfc4314Rights.w_Write_RIGHT);
            return hasWriteRight && (sharedFlags.contains(Flags.Flag.ANSWERED) || sharedFlags.contains(Flags.Flag.DRAFT) || sharedFlags.contains(Flags.Flag.FLAGGED) || sharedFlags.contains(Flags.Flag.RECENT) || sharedFlags.contains(Flags.Flag.USER));
        }
        return false;
    }

    @Override
    public MailboxACL.MailboxACLRights[] listRights(MailboxACL.MailboxACLEntryKey queryKey, GroupMembershipResolver groupMembershipResolver, String resourceOwner, boolean resourceOwnerIsGroup) throws UnsupportedRightException {
        MailboxACL.MailboxACLRights[] positiveNegativePair = new MailboxACL.MailboxACLRights[]{SimpleMailboxACL.NO_RIGHTS, SimpleMailboxACL.NO_RIGHTS};
        MailboxACL userACL = resourceOwnerIsGroup ? this.groupGlobalACL : this.userGlobalACL;
        this.resolveRights(queryKey, groupMembershipResolver, userACL.getEntries(), resourceOwner, resourceOwnerIsGroup, positiveNegativePair);
        if (queryKey.isNegative()) {
            return UnionMailboxACLResolver.toListRightsArray(positiveNegativePair[1]);
        }
        return UnionMailboxACLResolver.toListRightsArray(positiveNegativePair[0].except(positiveNegativePair[1]));
    }

    private static MailboxACL.MailboxACLRights[] toListRightsArray(MailboxACL.MailboxACLRights implicitRights) throws UnsupportedRightException {
        ArrayList<MailboxACL.MailboxACLRights> result = new ArrayList<MailboxACL.MailboxACLRights>(11);
        result.add(implicitRights);
        for (MailboxACL.MailboxACLRight right : SimpleMailboxACL.FULL_RIGHTS) {
            if (implicitRights.contains(right)) continue;
            result.add(new SimpleMailboxACL.Rfc4314Rights(right));
        }
        return result.toArray(new MailboxACL.MailboxACLRights[result.size()]);
    }

    @Override
    public MailboxACL.MailboxACLRights resolveRights(String requestUser, GroupMembershipResolver groupMembershipResolver, MailboxACL resourceACL, String resourceOwner, boolean resourceOwnerIsGroup) throws UnsupportedRightException {
        MailboxACL.MailboxACLRights[] positiveNegativePair = new MailboxACL.MailboxACLRights[]{SimpleMailboxACL.NO_RIGHTS, SimpleMailboxACL.NO_RIGHTS};
        SimpleMailboxACL.SimpleMailboxACLEntryKey queryKey = requestUser == null ? null : new SimpleMailboxACL.SimpleMailboxACLEntryKey(requestUser, MailboxACL.NameType.user, false);
        MailboxACL userACL = resourceOwnerIsGroup ? this.groupGlobalACL : this.userGlobalACL;
        this.resolveRights(queryKey, groupMembershipResolver, userACL.getEntries(), resourceOwner, resourceOwnerIsGroup, positiveNegativePair);
        if (resourceACL != null) {
            this.resolveRights(queryKey, groupMembershipResolver, resourceACL.getEntries(), resourceOwner, resourceOwnerIsGroup, positiveNegativePair);
        }
        return positiveNegativePair[0].except(positiveNegativePair[1]);
    }

    private void resolveRights(MailboxACL.MailboxACLEntryKey queryKey, GroupMembershipResolver groupMembershipResolver, Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> entries, String resourceOwner, boolean resourceOwnerIsGroup, MailboxACL.MailboxACLRights[] positiveNegativePair) throws UnsupportedRightException {
        if (entries != null) {
            for (Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> entry : entries.entrySet()) {
                MailboxACL.MailboxACLEntryKey key = entry.getKey();
                if (!UnionMailboxACLResolver.applies(key, queryKey, groupMembershipResolver, resourceOwner, resourceOwnerIsGroup)) continue;
                if (key.isNegative()) {
                    positiveNegativePair[1] = positiveNegativePair[1].union(entry.getValue());
                    continue;
                }
                positiveNegativePair[0] = positiveNegativePair[0].union(entry.getValue());
            }
        }
    }
}

