/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.mailbox.MailboxSession;

public class MailboxPath {
    private String namespace;
    private String user;
    private String name;

    public MailboxPath(String namespace, String user, String name) {
        this.namespace = namespace == null || namespace.equals("") ? "#private" : namespace;
        this.user = user;
        this.name = name;
    }

    public MailboxPath(MailboxPath mailboxPath) {
        this(mailboxPath.getNamespace(), mailboxPath.getUser(), mailboxPath.getName());
    }

    public MailboxPath(MailboxPath mailboxPath, String name) {
        this(mailboxPath.getNamespace(), mailboxPath.getUser(), name);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<MailboxPath> getHierarchyLevels(char delimiter) {
        ArrayList<MailboxPath> levels = new ArrayList<MailboxPath>();
        int index = this.name.indexOf(delimiter);
        while (index >= 0) {
            String levelname = this.name.substring(0, index);
            levels.add(new MailboxPath(this.namespace, this.user, levelname));
            ++index;
            index = this.name.indexOf(delimiter, index);
        }
        levels.add(this);
        return levels;
    }

    public String toString() {
        return this.namespace + ":" + this.user + ":" + this.name;
    }

    public boolean equals(Object mailboxPath) {
        if (this == mailboxPath) {
            return true;
        }
        if (!(mailboxPath instanceof MailboxPath)) {
            return false;
        }
        MailboxPath mp = (MailboxPath)mailboxPath;
        if (this.namespace == null ? mp.getNamespace() != null : !this.namespace.equals(mp.getNamespace())) {
            return false;
        }
        if (this.user == null ? mp.getUser() != null : !this.user.equals(mp.getUser())) {
            return false;
        }
        return !(this.name == null ? mp.getName() != null : !this.name.equals(mp.getName()));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        if (this.getName() != null) {
            result = 31 * result + this.getName().hashCode();
        }
        if (this.getUser() != null) {
            result = 31 * result + this.getUser().hashCode();
        }
        if (this.getNamespace() != null) {
            result = 31 * result + this.getNamespace().hashCode();
        }
        return result;
    }

    public String getFullName(char delimiter) {
        return this.namespace + delimiter + this.name;
    }

    public static MailboxPath inbox(MailboxSession session) {
        return new MailboxPath(session.getPersonalSpace(), session.getUser().getUserName(), "INBOX");
    }

    public static MailboxPath parse(MailboxSession session, String fullmailboxname) {
        char delimiter = session.getPathDelimiter();
        int i = fullmailboxname.indexOf(delimiter);
        String namespace = fullmailboxname.substring(0, i);
        String mailbox = fullmailboxname.substring(i + 1, fullmailboxname.length());
        String username = null;
        if (namespace == null || namespace.trim().equals("")) {
            namespace = "#private";
        }
        if (namespace.equals(session.getPersonalSpace())) {
            username = session.getUser().getUserName();
        }
        return new MailboxPath(namespace, username, mailbox);
    }
}

