/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.regex.Pattern;
import org.apache.james.mailbox.model.MailboxPath;

public final class MailboxQuery {
    private final MailboxPath base;
    private final String expression;
    private final char pathDelimiter;
    private final Pattern pattern;
    public static final char FREEWILDCARD = '*';
    public static final char LOCALWILDCARD = '%';

    public MailboxQuery(MailboxPath base, String expression, char pathDelimiter) {
        this.base = base;
        if (base.getName() == null) {
            this.base.setName("");
        }
        this.expression = expression == null ? "" : expression;
        this.pathDelimiter = pathDelimiter;
        this.pattern = Pattern.compile(this.expression.replaceAll("\\" + pathDelimiter, "\\\\" + pathDelimiter).replaceAll("\\*", "\\.\\*").replaceAll("\\%", "[^\\" + pathDelimiter + "]*"));
    }

    public final MailboxPath getBase() {
        return this.base;
    }

    public final String getExpression() {
        return this.expression;
    }

    public final char getFreeWildcard() {
        return '*';
    }

    public final char getLocalWildcard() {
        return '%';
    }

    public final boolean isExpressionMatch(String name) {
        boolean result = this.isWild() ? (name == null ? false : this.pattern.matcher(name).matches()) : this.expression.equals(name);
        return result;
    }

    public String getCombinedName() {
        String result;
        if (this.base != null && this.base.getName() != null && this.base.getName().length() > 0) {
            int baseLength = this.base.getName().length();
            result = this.base.getName().charAt(baseLength - 1) == this.pathDelimiter ? (this.expression != null && this.expression.length() > 0 ? (this.expression.charAt(0) == this.pathDelimiter ? this.base.getName() + this.expression.substring(1) : this.base.getName() + this.expression) : this.base.getName()) : (this.expression != null && this.expression.length() > 0 ? (this.expression.charAt(0) == this.pathDelimiter ? this.base.getName() + this.expression : this.base.getName() + this.pathDelimiter + this.expression) : this.base.getName());
        } else {
            result = this.expression;
        }
        return result;
    }

    public boolean isWild() {
        return this.expression != null && (this.expression.indexOf(this.getFreeWildcard()) >= 0 || this.expression.indexOf(this.getLocalWildcard()) >= 0);
    }

    public String toString() {
        String TAB = " ";
        return "MailboxExpression [ base = " + this.base + " " + "expression = " + this.expression + " " + "freeWildcard = " + this.getFreeWildcard() + " " + "localWildcard = " + this.getLocalWildcard() + " " + " ]";
    }
}

