/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MessageRange
implements Iterable<Long> {
    public static final long NOT_A_UID = -1L;
    public static final long MAX_UID = Long.MAX_VALUE;
    private final Type type;
    private final long uidFrom;
    private final long uidTo;

    public static MessageRange one(long uid) {
        MessageRange result = new MessageRange(Type.ONE, uid, uid);
        return result;
    }

    public static MessageRange all() {
        MessageRange result = new MessageRange(Type.ALL, -1L, Long.MAX_VALUE);
        return result;
    }

    public static MessageRange range(long from, long to) {
        MessageRange result;
        if (to == Long.MAX_VALUE || to < from) {
            to = -1L;
            result = MessageRange.from(from);
        } else {
            result = from == to ? MessageRange.one(from) : new MessageRange(Type.RANGE, from, to);
        }
        return result;
    }

    public static MessageRange from(long from) {
        MessageRange result = new MessageRange(Type.FROM, from, -1L);
        return result;
    }

    protected MessageRange(Type type, long uidFrom, long uidTo) {
        this.type = type;
        this.uidFrom = uidFrom;
        this.uidTo = uidTo;
    }

    public Type getType() {
        return this.type;
    }

    public long getUidFrom() {
        return this.uidFrom;
    }

    public long getUidTo() {
        return this.uidTo;
    }

    public boolean includes(long uid) {
        switch (this.type) {
            case ALL: {
                return true;
            }
            case FROM: {
                if (uid > this.getUidFrom()) {
                    return true;
                }
            }
            case RANGE: {
                if (uid >= this.getUidFrom() && uid <= this.getUidTo()) {
                    return true;
                }
            }
            case ONE: {
                if (this.getUidFrom() != uid) break;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "TYPE: " + (Object)((Object)this.type) + " UID: " + this.uidFrom + ":" + this.uidTo;
    }

    public static List<MessageRange> toRanges(Collection<Long> uidsCol) {
        ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
        ArrayList<Long> uids = new ArrayList<Long>(uidsCol);
        Collections.sort(uids);
        long firstUid = 0L;
        int a = 0;
        for (int i = 0; i < uids.size(); ++i) {
            long u = (Long)uids.get(i);
            if (i == 0) {
                firstUid = u;
                if (uids.size() != 1) continue;
                ranges.add(MessageRange.one(firstUid));
                continue;
            }
            if (firstUid + (long)a + 1L != u) {
                ranges.add(MessageRange.range(firstUid, firstUid + (long)a));
                firstUid = u;
                a = 0;
                if (uids.size() > i + 1) continue;
                ranges.add(MessageRange.one(firstUid));
                continue;
            }
            ++a;
            if (uids.size() > i + 1) continue;
            ranges.add(MessageRange.range(firstUid, firstUid + (long)a));
            break;
        }
        return ranges;
    }

    @Override
    public Iterator<Long> iterator() {
        long to;
        long from = this.getUidFrom();
        if (from == -1L) {
            from = 1L;
        }
        if ((to = this.getUidTo()) == -1L) {
            to = Long.MAX_VALUE;
        }
        return new RangeIterator(from, to);
    }

    public List<MessageRange> split(int maxItems) {
        ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
        if (this.getType() == Type.RANGE) {
            long to;
            long from = this.getUidFrom();
            long realTo = to = this.getUidTo();
            while (from <= realTo) {
                to = from + (long)maxItems - 1L < realTo ? from + (long)maxItems - 1L : realTo;
                if (from == to) {
                    ranges.add(MessageRange.one(from));
                } else {
                    ranges.add(MessageRange.range(from, to));
                }
                from = to + 1L;
            }
        } else {
            ranges.add(this);
        }
        return ranges;
    }

    private final class RangeIterator
    implements Iterator<Long> {
        private long to;
        private long current;

        public RangeIterator(long from, long to) {
            this.to = to;
            this.current = from;
        }

        @Override
        public boolean hasNext() {
            return this.current <= this.to;
        }

        @Override
        public Long next() {
            if (this.hasNext()) {
                return this.current++;
            }
            throw new NoSuchElementException("Max uid of " + this.to + " was reached before");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-Only");
        }
    }

    public static enum Type {
        ALL,
        ONE,
        FROM,
        RANGE;

    }
}

