/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.MailboxSession;

public class MailboxPath {
    private final String namespace;
    private final String user;
    private final String name;

    public static MailboxPath inbox(MailboxSession session) {
        return MailboxPath.forUser(session.getUser().getUserName(), "INBOX");
    }

    public static MailboxPath forUser(String username, String mailboxName) {
        return new MailboxPath("#private", username, mailboxName);
    }

    public MailboxPath(String namespace, String user, String name) {
        this.namespace = Optional.ofNullable(namespace).filter(s -> !s.isEmpty()).orElse("#private");
        this.user = user;
        this.name = name;
    }

    public MailboxPath(MailboxPath mailboxPath) {
        this(mailboxPath.getNamespace(), mailboxPath.getUser(), mailboxPath.getName());
    }

    public MailboxPath(MailboxPath mailboxPath, String name) {
        this(mailboxPath.getNamespace(), mailboxPath.getUser(), name);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public boolean belongsTo(MailboxSession mailboxSession) {
        return mailboxSession.getUser().isSameUser(this.user);
    }

    public List<MailboxPath> getHierarchyLevels(char delimiter) {
        if (this.name == null) {
            return ImmutableList.of((Object)this);
        }
        ArrayList<MailboxPath> levels = new ArrayList<MailboxPath>();
        int index = this.name.indexOf(delimiter);
        while (index >= 0) {
            String levelname = this.name.substring(0, index);
            levels.add(new MailboxPath(this.namespace, this.user, levelname));
            ++index;
            index = this.name.indexOf(delimiter, index);
        }
        levels.add(this);
        return levels;
    }

    public MailboxPath sanitize(char delimiter) {
        if (this.name == null) {
            return this;
        }
        if (this.name.endsWith(String.valueOf(delimiter))) {
            int length = this.name.length();
            String sanitizedName = this.name.substring(0, length - 1);
            return new MailboxPath(this.namespace, this.user, sanitizedName);
        }
        return this;
    }

    public String asString() {
        return this.namespace + ":" + this.user + ":" + this.name;
    }

    public boolean isInbox() {
        return "INBOX".equalsIgnoreCase(this.name);
    }

    public String toString() {
        return this.asString();
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxPath) {
            MailboxPath that = (MailboxPath)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.user, that.user) && Objects.equals(this.name, that.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.namespace, this.user, this.name);
    }

    public String getFullName(char delimiter) {
        return this.namespace + delimiter + this.name;
    }
}

