/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.james.core.quota.QuotaValue;

public class Quota<T extends QuotaValue<T>> {
    private final T limit;
    private final ImmutableMap<Scope, T> limitByScope;
    private final T used;

    public static <T extends QuotaValue<T>> Builder<T> builder() {
        return new Builder();
    }

    private Quota(T used, T max, ImmutableMap<Scope, T> limitByScope) {
        this.used = used;
        this.limit = max;
        this.limitByScope = limitByScope;
    }

    public T getLimit() {
        return this.limit;
    }

    public T getUsed() {
        return this.used;
    }

    public double getRatio() {
        if (this.limit.isUnlimited()) {
            return 0.0;
        }
        return Double.valueOf(this.used.asLong()) / Double.valueOf(this.limit.asLong());
    }

    public ImmutableMap<Scope, T> getLimitByScope() {
        return this.limitByScope;
    }

    public Quota<T> addValueToQuota(T value) {
        return new Quota<QuotaValue>(this.used.add(value), (QuotaValue)this.limit, (ImmutableMap<Scope, QuotaValue>)this.limitByScope);
    }

    public boolean isOverQuota() {
        return this.isOverQuotaWithAdditionalValue(0L);
    }

    public boolean isOverQuotaWithAdditionalValue(long additionalValue) {
        Preconditions.checkArgument((additionalValue >= 0L ? 1 : 0) != 0);
        return this.limit.isLimited() && this.used.add(additionalValue).isGreaterThan(this.limit);
    }

    public String toString() {
        return this.used + "/" + this.limit;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Quota)) {
            return false;
        }
        Quota other = (Quota)o;
        return Objects.equal(this.used, other.getUsed()) && Objects.equal(this.limit, other.getLimit());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.used, this.limit});
    }

    /* synthetic */ Quota(QuotaValue x0, QuotaValue x1, ImmutableMap x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static class Builder<T extends QuotaValue<T>> {
        private final ImmutableMap.Builder<Scope, T> limitsByScope = ImmutableMap.builder();
        private T computedLimit;
        private T used;

        private Builder() {
        }

        public Builder<T> computedLimit(T limit) {
            this.computedLimit = limit;
            return this;
        }

        public Builder<T> used(T used) {
            this.used = used;
            return this;
        }

        public Builder<T> limitsByScope(Map<Scope, T> limits) {
            this.limitsByScope.putAll(limits);
            return this;
        }

        public Builder<T> limitForScope(T limit, Scope scope) {
            this.limitsByScope.put((Object)scope, limit);
            return this;
        }

        public Quota<T> build() {
            Preconditions.checkState((this.used != null ? 1 : 0) != 0);
            Preconditions.checkState((this.computedLimit != null ? 1 : 0) != 0);
            return new Quota((QuotaValue)this.used, (QuotaValue)this.computedLimit, this.limitsByScope.build(), null);
        }
    }

    public static enum Scope {
        Domain,
        Global,
        User;

    }
}

