/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.model.Quota;

public class QuotaRatio {
    private final Quota<QuotaSize> quotaSize;
    private final Quota<QuotaCount> quotaCount;

    public static QuotaRatio from(Quota<QuotaSize> quotaSize, Quota<QuotaCount> quotaCount) {
        return new QuotaRatio(quotaSize, quotaCount);
    }

    private QuotaRatio(Quota<QuotaSize> quotaSize, Quota<QuotaCount> quotaCount) {
        Preconditions.checkNotNull(quotaSize, (Object)"'quotaSize' is mandatory");
        Preconditions.checkNotNull(quotaCount, (Object)"'quotaCount' is mandatory");
        this.quotaSize = quotaSize;
        this.quotaCount = quotaCount;
    }

    public Quota<QuotaSize> getQuotaSize() {
        return this.quotaSize;
    }

    public Quota<QuotaCount> getQuotaCount() {
        return this.quotaCount;
    }

    public double max() {
        return Math.max(this.quotaSize.getRatio(), this.quotaCount.getRatio());
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaRatio) {
            QuotaRatio quotaRatio = (QuotaRatio)o;
            return Objects.equals(this.quotaSize, quotaRatio.quotaSize) && Objects.equals(this.quotaCount, quotaRatio.quotaCount);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.quotaSize, this.quotaCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("quotaSize", this.quotaSize).add("quotaCount", this.quotaCount).toString();
    }
}

