/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.Wildcard;

public final class MailboxQuery {
    private final Optional<String> namespace;
    private final Optional<String> user;
    private final MailboxNameExpression mailboxNameExpression;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder privateMailboxesBuilder(MailboxSession session) {
        return MailboxQuery.builder().namespace("#private").username(session.getUser().getUserName()).matchesAllMailboxNames();
    }

    @VisibleForTesting
    MailboxQuery(Optional<String> namespace, Optional<String> user, MailboxNameExpression mailboxNameExpression) {
        this.namespace = namespace;
        this.user = user;
        this.mailboxNameExpression = mailboxNameExpression;
    }

    public Optional<String> getNamespace() {
        return this.namespace;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public MailboxNameExpression getMailboxNameExpression() {
        return this.mailboxNameExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPrivateMailboxes(MailboxSession session) {
        MailboxSession.User sessionUser = session.getUser();
        if (this.namespace.map("#private"::equals).orElse(false) == false) return false;
        if (this.user.map(sessionUser::isSameUser).orElse(false) == false) return false;
        return true;
    }

    @VisibleForTesting
    boolean belongsToRequestedNamespaceAndUser(MailboxPath mailboxPath) {
        boolean belongsToRequestedNamespace = this.namespace.map(value -> value.equals(mailboxPath.getNamespace())).orElse(true);
        boolean belongsToRequestedUser = this.user.map(value -> value.equals(mailboxPath.getUser())).orElse(true);
        return belongsToRequestedNamespace && belongsToRequestedUser;
    }

    public boolean isExpressionMatch(String name) {
        return this.mailboxNameExpression.isExpressionMatch(name);
    }

    public boolean isPathMatch(MailboxPath mailboxPath) {
        return this.belongsToRequestedNamespaceAndUser(mailboxPath) && this.isExpressionMatch(mailboxPath.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", this.namespace).add("user", this.user).add("mailboxNameExpression", (Object)this.mailboxNameExpression).toString();
    }

    public static class Builder {
        private static final Wildcard DEFAULT_WILDCARD = Wildcard.INSTANCE;
        Optional<String> username;
        Optional<String> namespace = Optional.empty();
        Optional<MailboxNameExpression> mailboxNameExpression;

        private Builder() {
            this.username = Optional.empty();
            this.mailboxNameExpression = Optional.empty();
        }

        public Builder userAndNamespaceFrom(MailboxPath base) {
            Preconditions.checkState((!this.namespace.isPresent() ? 1 : 0) != 0);
            Preconditions.checkState((!this.username.isPresent() ? 1 : 0) != 0);
            this.namespace = Optional.ofNullable(base.getNamespace());
            this.username = Optional.ofNullable(base.getUser());
            return this;
        }

        public Builder username(String username) {
            Preconditions.checkState((!this.username.isPresent() ? 1 : 0) != 0);
            this.username = Optional.of(username);
            return this;
        }

        public Builder namespace(String namespace) {
            Preconditions.checkState((!this.namespace.isPresent() ? 1 : 0) != 0);
            this.namespace = Optional.of(namespace);
            return this;
        }

        public Builder privateNamespace() {
            Preconditions.checkState((!this.namespace.isPresent() ? 1 : 0) != 0);
            this.namespace = Optional.of("#private");
            return this;
        }

        public Builder expression(MailboxNameExpression expression) {
            this.mailboxNameExpression = Optional.of(expression);
            return this;
        }

        public Builder matchesAllMailboxNames() {
            this.mailboxNameExpression = Optional.of(Wildcard.INSTANCE);
            return this;
        }

        public MailboxQuery build() {
            return new MailboxQuery(this.namespace, this.username, this.mailboxNameExpression.orElse(DEFAULT_WILDCARD));
        }
    }
}

