/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import java.util.stream.Stream;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.PositiveUserACLDiff;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PositiveUserACLDiffTest {
    private static final Username USER = Username.of((String)"user");
    private static final MailboxACL.EntryKey USER_ENTRY_KEY = MailboxACL.EntryKey.createUserEntryKey((Username)USER);
    private static final MailboxACL.EntryKey NEGATIVE_USER_ENTRY_KEY = MailboxACL.EntryKey.createUserEntryKey((Username)USER, (boolean)true);
    private static final MailboxACL.EntryKey GROUP_ENTRY_KEY = MailboxACL.EntryKey.createGroupEntryKey((String)"group");
    private static final MailboxACL.Rfc4314Rights RIGHTS = new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Administer});

    PositiveUserACLDiffTest() {
    }

    @Test
    void addedEntriesShouldReturnEmptyWhenSameACL() {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)positiveUserAclDiff.addedEntries()).isEmpty();
    }

    @Test
    void addedEntriesShouldReturnEmptyWhenSameNonEmptyACL() throws UnsupportedRightException {
        MailboxACL mailboxACL = MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition());
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)mailboxACL, (MailboxACL)mailboxACL);
        Assertions.assertThat((Stream)positiveUserAclDiff.addedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldReturnEmptyWhenSameACL() {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)positiveUserAclDiff.removedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldReturnEmptyWhenSameNonEmptyACL() throws UnsupportedRightException {
        MailboxACL mailboxACL = MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition());
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)mailboxACL, (MailboxACL)mailboxACL);
        Assertions.assertThat((Stream)positiveUserAclDiff.removedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldReturnEmptyWhenSameACL() {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)positiveUserAclDiff.changedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldReturnEmptyWhenSameNonEmptyACL() throws UnsupportedRightException {
        MailboxACL mailboxACL = MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition());
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)mailboxACL, (MailboxACL)mailboxACL);
        Assertions.assertThat((Stream)positiveUserAclDiff.changedEntries()).isEmpty();
    }

    @Test
    void addedEntriesShouldReturnNewEntryWhenAddedEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.addedEntries()).containsOnly((Object[])new MailboxACL.Entry[]{new MailboxACL.Entry(USER_ENTRY_KEY, RIGHTS)});
    }

    @Test
    void addedEntriesShouldFilterNonUserEntryKey() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(GROUP_ENTRY_KEY).rights(RIGHTS).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.addedEntries()).isEmpty();
    }

    @Test
    void addedEntriesShouldFilterNegativeUserEntryKey() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(NEGATIVE_USER_ENTRY_KEY).rights(RIGHTS).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.addedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldReturnEmptyWhenAddedEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.changedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldReturnEmptyWhenAddedEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.removedEntries()).isEmpty();
    }

    @Test
    void addedEntriesShouldReturnEmptyWhenRemovedEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)positiveUserAclDiff.addedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldReturnEmptyWhenRemovedEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)positiveUserAclDiff.changedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldReturnEntryWhenRemovedEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)positiveUserAclDiff.removedEntries()).containsOnly((Object[])new MailboxACL.Entry[]{new MailboxACL.Entry(USER_ENTRY_KEY, RIGHTS)});
    }

    @Test
    void removedEntriesShouldFilterNonUserEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(GROUP_ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)positiveUserAclDiff.removedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldFilterNegativeUserEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(NEGATIVE_USER_ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)positiveUserAclDiff.removedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldReturnEmptyWhenChangedEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.removedEntries()).isEmpty();
    }

    @Test
    void addedEntriesShouldReturnEmptyWhenChangedEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.addedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldReturnEntryWhenChangedEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Administer}).asAddition()), (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(USER_ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.changedEntries()).containsOnly((Object[])new MailboxACL.Entry[]{new MailboxACL.Entry(USER_ENTRY_KEY, new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}))});
    }

    @Test
    void changedEntriesShouldFilterNonUserEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(GROUP_ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Administer}).asAddition()), (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(GROUP_ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.changedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldFilterNegativeUserEntry() throws Exception {
        PositiveUserACLDiff positiveUserAclDiff = PositiveUserACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(NEGATIVE_USER_ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Administer}).asAddition()), (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(NEGATIVE_USER_ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).asAddition()));
        Assertions.assertThat((Stream)positiveUserAclDiff.changedEntries()).isEmpty();
    }
}

